INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_strstr:FN_CALL PTR
p_fn_fc_strstr LABEL FN_CALL PTR
	P_FN_CALL @strstr
	P_FN_CALL @strstr_sss
	P_FN_CALL @strstr_dss
_DATA ENDS

 ENDIF
ENDIF

;strstr() -- Search p_str1 for substring p_str2
;char __near *	fn_call strstr(const char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (src) offset from ds
; RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to substring, if found
;		to terminating '\0' if not found
;		to terminating '\0' if strlen(str2) > strlen(str1)
; NOTES:
; the strstr functions push/pop data on/off the stack, this may or may not
; cause problems with some stack checkers.
; most of the fastcall versions, becuase of the lack of registers, are probably
;  slower than the _cdecl versions.
CLIBC_16_CS SEGMENT
strstr PROC FN_CALL C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

    mov ax, ds
    mov es, ax

    mov si, [p_str1]
    mov di, [p_str2]
    cmp si, di
    jne @@cont
    mov ax, di
    jmp @@exit

@@cont:
    ; get bytes in p_str2 (substring, src), includes ending 0
    mov ax, ds
    mov es, ax
    mov di, [p_str2] ; es:di = p_str2
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = len substring
    ; ax=0000, bx=bytes(p_str2)

    ; get bytes in p_str1 (search string, dest), includes ending 0
    mov di, [p_str1] ; es:di = p_str1
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    push di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2)
    ; stk=p_st1(ending 0)

    ; check to see if cx==1, empty search string
    cmp cx, 1
    jg @F
    pop ax
    jmp @@exit
@@:
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than search string
    pop ax
    jmp @@exit

@@:
;    sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    mov di, [p_str2]	    ;es:di = substring pointer
    mov si, [p_str1]	    ; ds:si = search string pointer
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	jmp @@notfoundit    ; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
@@notfoundit:
	; not found
	    pop cx ; restore old pointer
	    pop si
	    inc si
	    mov di, [p_str2]	; restore pointer to substring
	    mov al, es:[di]	; first char of substring
	    dec bx
	    jz @@done
	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si
	    pop cx ; clear stack
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax  ; old pointer
@@exit:
    ret
strstr	    ENDP

; __fastcall
;	bx	p_str1	near pointer, (dest) offset from ds
;	ax	p_str2	near pointer, (src) offset from ds
;char __near *	__fastcall fn_call strstr(const char __near * const, const char __near * const);
@strstr PROC FN_CALL USES es si di bx cx dx

;   bx = p_str1 (si)
;   ax = p_str2 (di)
    mov cx, ds
    mov es, cx

    cmp ax, bx
    jne @@cont
    ; ax = bx= p_str1
    jmp @@exit	; pointers are equal, done

@@cont:
    ; bx=p_str1, ax=p_str2
    push ax
    push bx ; stk=p_str1, p_str2
    ; get # of bytes in p_str2 (substring,src)
    mov dx, bx	; dx=p_str1
    mov di, ax	; di=p_str2
    xor ax, ax
    mov cx, ax
    dec cx	; cx = -1, ax=0000
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = bytes(p_str2)
    ; ax=0000, di=p_str2(after 0), cx=bytes(p_str2), bx=bytes(p_str2), dx=p_str1
    ; stk=p_str1, p_str2

    ; bytes in p_str1 (search string,dest)
    mov di, dx	; di=p_str1
    mov cx, ax
    dec cx  ; cx=-1
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    mov dx, di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2), dx=di=p_str2(to 0)
    ; stk=p_str1, p_str2

    ; check to see if cx==1, if so, empty src string
    cmp cx, 1
    jg @F
    ; p_str2 is empty
    mov ax, dx
    pop bx
    pop bx ; clean up stack
    jmp @@exit
@@:
    ; check to see if substring(p_str2,src) is longer than search string(p_str1,dest)
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than string
    mov ax, dx
    pop bx
    pop bx ;clean up stack
    jmp @@exit
@@:
    ;sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    pop si	    ; ds:si = search string pointer, p_str1, dest
    pop di	    ; es:di = substring pointer, p_str2, src
    push dx	    ; dx = p_str2(at 0)
    mov dx, di
    ; ax=0000, bx=bytes(str_1) to check, cx=bytes(p_str2), dx=p_str2
    ; di=p_str2, si=p_str1
    ; stk=p_str2(at 0)
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of search string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	    jmp @@notfoundit	; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
	@@notfoundit:
	    ; not found
	    pop cx ; restore old counter
	    pop si ; restore old pointer
	    mov di, dx	; restore pointer to substring
	    mov al, es:[di]	; restore first char of substring
	    jmp @@notequal
;	    inc si
;	    dec bx
;	    jz @@done
;	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si, pointer to p_str1(match start), also ret val
	    pop cx  ; remove old pointer to zero
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax
@@exit:
    ret
@strstr ENDP

;strstr_sss() -- Search p_str1 for substring p_str2
;char __near *	fn_call strstr_sss(const char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, (dest) offset from ds
;   p_str2	near pointer, (src) offset from ss
; RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to substring, if found
;		to terminating '\0' if not found
;		to terminating '\0' if strlen(str2) > strlen(str1)

strstr_sss PROC FN_CALL C USES ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

    mov ax, ds
    mov es, ax
    mov bx, ss
    mov ds, ax
    mov si, [p_str1]	; ds:si=p_str1=substring=src
    mov di, [p_str2]	; es:di=p_str2=search string=dest

    cmp ax, bx
    jne @@cont
    cmp si, di
    jne @@cont
    mov ax, di
    jmp @@exit

@@cont:
    ; get bytes in p_str2 (substring, src), includes ending 0
    mov ax, ss
    mov es, ax
    mov di, [p_str2] ; es:di = p_str2
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = len substring
    ; ax=0000, bx=bytes(p_str2)

    ; get bytes in p_str1 (search string, dest), includes ending 0
    mov ax, ds
    mov es, ax
    mov di, [p_str1] ; es:di = p_str1
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    push di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2)
    ; stk=p_st1(ending 0)

    ; check to see if cx==1, empty search string
    cmp cx, 1
    jg @F
    pop ax
    jmp @@exit
@@:
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than search string
    pop ax
    jmp @@exit

@@:
;    sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    mov ax, ss
    mov es, ax
    mov di, [p_str2]	    ;es:di = substring pointer
    mov si, [p_str1]	    ; ds:si = search string pointer
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	jmp @@notfoundit    ; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
@@notfoundit:
	; not found
	    pop cx ; restore old pointer
	    pop si
	    inc si
	    mov di, [p_str2]	; restore pointer to substring
	    mov al, es:[di]	; first char of substring
	    dec bx
	    jz @@done
	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si
	    pop cx ; clear stack
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax  ; old pointer
@@exit:
    ret
strstr_sss    ENDP

; __fastcall
;	bx	p_str1	near pointer, (dest) offset from ds
;	ax	p_str2	near pointer, (src) offset from ss
;char __near *	__fastcall fn_call strstr_sss(const char __near * const, const char __near * const);
@strstr_sss PROC FN_CALL USES ds es si di bx cx dx

;   bx = p_str1 (si)
;   ax = p_str2 (di)
    mov cx, ds
    mov dx, ss

    cmp cx, dx
    jne @@cont
    cmp ax, bx
    jne @@cont
    ; p_str1 = p_str2 =ax =bx
    jmp @@exit	; pointers are equal, done

@@cont:
    ; bx=p_str1, ax=p_str2
    push ax
    push bx ; stk=p_str1, p_str2
    ; get # of bytes in p_str2 (substring,src)
    mov es, dx	; ss
    mov dx, bx	; dx=p_str1
    mov di, ax	; di=p_str2
    xor ax, ax
    mov cx, ax
    dec cx	; cx = -1, ax=0000
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = bytes(p_str2)
    ; ax=0000, di=p_str2(after 0), cx=bytes(p_str2), bx=bytes(p_str2), dx=p_str1
    ; stk=p_str1, p_str2

    ; bytes in p_str1 (search string,dest)
    mov di, dx	; di=p_str1
    push ds
    pop es  ; es = ds
    mov cx, ax
    dec cx  ; cx=-1
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    mov dx, di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2), dx=di=p_str2(to 0)
    ; stk=p_str1, p_str2

    ; check to see if cx==1, if so, empty src string
    cmp cx, 1
    jg @F
    ; p_str2 is empty
    mov ax, dx
    pop bx
    pop bx ; clean up stack
    jmp @@exit
@@:
    ; check to see if substring(p_str2,src) is longer than search string(p_str1,dest)
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than string
    mov ax, dx
    pop bx
    pop bx ;clean up stack
    jmp @@exit
@@:
    ;sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    pop si	    ; ds:si = search string pointer, p_str1, dest
    pop di	    ; es:di = substring pointer, p_str2, src
    push ss
    pop es	    ; es = ss
    push dx	    ; dx = p_str2(at 0)
    mov dx, di
    ; ax=0000, bx=bytes(str_1) to check, cx=bytes(p_str2), dx=p_str2
    ; di=p_str2, si=p_str1
    ; stk=p_str2(at 0)
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of search string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	    jmp @@notfoundit	; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
	@@notfoundit:
	    ; not found
	    pop cx ; restore old counter
	    pop si ; restore old pointer
	    mov di, dx	; restore pointer to substring
	    mov al, es:[di]	; restore first char of substring
	    jmp @@notequal
;	    inc si
;	    dec bx
;	    jz @@done
;	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si, pointer to p_str1(match start), also ret val
	    pop cx  ; remove old pointer to zero
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax
@@exit:
    ret
@strstr_sss    ENDP

;strstr_dss() -- Search p_str1 for substring p_str2
;char __near *	fn_call strstr_dss(const char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (src) offset from ds
; RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to substring, if found
;		to terminating '\0' if not found
;		to terminating '\0' if strlen(str2) > strlen(str1)
strstr_dss PROC FN_CALL C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

    mov ax, ds
    mov es, ax
    mov bx, ss
    mov ds, ax
    mov si, [p_str1]	; ds:si=p_str1=substring=src
    mov di, [p_str2]	; es:di=p_str2=search string=dest

    cmp ax, bx
    jne @@cont
    cmp si, di
    jne @@cont
    mov ax, di
    jmp @@exit

@@cont:
    ; get bytes in p_str2 (substring, src), includes ending 0
    mov ax, ds
    mov es, ax
    mov di, [p_str2] ; es:di = p_str2
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = len substring
    ; ax=0000, bx=bytes(p_str2)

    ; get bytes in p_str1 (search string, dest), includes ending 0
    mov ax, ss
    mov es, ax
    mov di, [p_str1] ; es:di = p_str1
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    push di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2)
    ; stk=p_st1(ending 0)

    ; check to see if cx==1, empty search string
    cmp cx, 1
    jg @F
    pop ax
    jmp @@exit
@@:
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than search string
    pop ax
    jmp @@exit

@@:
;    sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    mov ax, ds
    mov es, ax
    mov ax, ss
    mov ds, ax
    mov di, [p_str2]	    ;es:di = substring pointer
    mov si, [p_str1]	    ; ds:si = search string pointer
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	jmp @@notfoundit    ; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
@@notfoundit:
	; not found
	    pop cx ; restore old pointer
	    pop si
	    inc si
	    mov di, [p_str2]	; restore pointer to substring
	    mov al, es:[di]	; first char of substring
	    dec bx
	    jz @@done
	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si
	    pop cx ; clear stack
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax  ; old pointer
@@exit:
    ret
strstr_dss    ENDP

; __fastcall
;	bx	p_str1	near pointer, (dest) offset from ss
;	ax	p_str2	near pointer, (src) offset from ds
;char __near *	__fastcall fn_call strstr_dss(const char __near * const, const char __near * const);
@strstr_dss PROC FN_CALL USES ds es si di

;   bx = p_str1 (si)
;   ax = p_str2 (di)
    mov cx, ds
    mov dx, ss

    cmp cx, dx
    jne @@cont
    cmp ax, bx
    jne @@cont
    ; p_str1 = p_str2 =ax =bx
    jmp @@exit	; pointers are equal, done

@@cont:
    ; bx=p_str1, ax=p_str2
    push ax
    push bx ; stk=p_str1, p_str2
    ; get # of bytes in p_str2 (substring,src)
    mov es, cx	; ds
    mov dx, bx	; dx=p_str1
    mov di, ax	; di=p_str2
    xor ax, ax
    mov cx, ax
    dec cx	; cx = -1, ax=0000
    repne scas BYTE PTR es:[di]
    not cx
    mov bx, cx ;bx = bytes(p_str2)
    ; ax=0000, di=p_str2(after 0), cx=bytes(p_str2), bx=bytes(p_str2), dx=p_str1
    ; stk=p_str1, p_str2

    ; bytes in p_str1 (search string,dest)
    mov di, dx	; di=p_str1
    push ss
    pop es  ; es = ss
    mov cx, ax
    dec cx  ; cx=-1
    repne scas BYTE PTR es:[di]
    not cx
    dec di
    mov dx, di
    xchg cx, bx
    ; ax=0000, bx=bytes(p_str1), cx=bytes(p_str2), dx=di=p_str2(to 0)
    ; stk=p_str1, p_str2

    ; check to see if cx==1, if so, empty src string
    cmp cx, 1
    jg @F
    ; p_str2 is empty
    mov ax, dx
    pop bx
    pop bx ; clean up stack
    jmp @@exit
@@:
    ; check to see if substring(p_str2,src) is longer than search string(p_str1,dest)
    sub bx, cx	; cmp bx, cx
    jge @F
    ; cannot be, substring longer than string
    mov ax, dx
    pop bx
    pop bx ;clean up stack
    jmp @@exit
@@:
    ;sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check
    dec cx
    ; cx = number of bytes in str2 to use when checking (ie without 0)
    pop si	    ; ds:si = search string pointer, p_str1, dest
    pop di	    ; es:di = substring pointer, p_str2, src
    push ds
    pop es	    ; es = ds
    push ss
    pop ds	    ; ds = ss
    push dx	    ; dx = p_str2(at 0)
    mov dx, di
    ; ax=0000, bx=bytes(str_1) to check, cx=bytes(p_str2), dx=p_str2
    ; di=p_str2, si=p_str1
    ; stk=p_str2(at 0)
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of search string
    cmp al, ah
    jne @@notequal
    ; each char is equal, maybe the rest of the chars are also
    ;	ds:[si] points to char in string, that is equal to first char in sub
    ;	cx bytes in substring to use when checking
	push si ; save current pointer into search string
	push cx ; save substring bytes
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	    jmp @@notfoundit	; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
	@@notfoundit:
	    ; not found
	    pop cx ; restore old counter
	    pop si ; restore old pointer
	    mov di, dx	; restore pointer to substring
	    mov al, es:[di]	; restore first char of substring
	    jmp @@notequal
;	    inc si
;	    dec bx
;	    jz @@done
;	    jmp @@loop
@@foundit:
	    ; found the string
	    pop cx ; restore old pointer
	    pop ax ; was push si, pointer to p_str1(match start), also ret val
	    pop cx  ; remove old pointer to zero
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    pop ax
@@exit:
    ret
@strstr_dss    ENDP

CLIBC_16_CS ENDS
END
