INCLUDE CLIBC_16.INC


;strstr() -- Search p_str1 for substring p_str2
;char __near *	__near strstr(const char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ss
;   p_str2	near pointer, offset from ds
; RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to substring, if found
;		to terminating '\0' if not found
;		to terminating '\0' if strlen(str2) > strlen(str1)

_TEXT SEGMENT
strstr PROC NEAR16 C USES es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
    LOCAL p_temp:NEAR16 PTR BYTE


    mov ax, ss
    mov bx, ds
    cmp ax, bx
    jne @@cont
    mov si, [p_str1]
    mov di, [p_str2]
    cmp si, di
    jne @@cont
    mov ax, di
    jmp @@exit

@@cont:
    ; get string length of p_str2 (substring)

    mov ax, ds
    mov es, ax
    mov di,[p_str2] ; es/ds:di = p_str2
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    mov bx, cx ;bx = len substring

    mov cx, ss
    mov es, cx

    ; get string length of p_str1 (string)
    mov di, [p_str1] ; es/ss:di = p_str1
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec cx

    dec di
    mov [p_temp], di ; p_temp = end of str1
    xchg cx, bx
    ; bx = len str1, cx= len str2
    cmp cx, bx
    jle @F
    ; cannot be, substring longer than string
    mov ax, di
    jmp @@exit

@@:
    dec cx
    ; bx = strlen(str1), cx=strlen(str2)
    sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check

    mov di, [p_str2]	    ;es/ss:di = substring pointer
    mov si, [p_str1]	    ; ds:si = string pointer
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, [si]	; ds:[si], next char of string
    cmp al, ah
    jne @@notequal
    ; first chars are equal, maybe the rest of the string is also
    ;  ds:[si] points to char in string, that is equal to first char in sub
    ;  cx length of substring
	push cx ; save substring strlength
	push si ; save current pointer into string
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F     ; if cx==0, then MAY have found it
	jmp @@notfoundit    ; cx != 0, then did NOT find it
	@@:
	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
@@notfoundit:
	; not found
	    pop si
	    pop cx ; restore old pointer
	    inc si
	    mov di, [p_str2]	; restore pointer to substring
	    mov al, es:[di]	; first char of substring
	    dec bx
	    jz @@done
	    jmp @@loop
@@foundit:
	    ; found the string
	    pop ax ; was push si
	    pop cx ; restore old pointer
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    mov ax, WORD PTR [p_temp]
@@exit:
    ret
strstr	    ENDP

; NOT WORKING, ran out of registers, do not want to use stack
; __fastcall
;	bx	p_str1
;	ax	p_str2
;char __near *	__fastcall __near strstr(const char __near * const, const char __near * const);
;@strstr PROC NEAR16 USES es si di bx cx dx
;
;    mov si, bx	; ds:si = p_str1
;    mov di, ax	; es:di = p_str2
;    mov cx, ss
;    mov dx, ds
;    cmp cx, dx
;    jne @@cont
;    cmp si, di
;    jne @@cont
;		 ; ax = di
;    jmp @@exit
;
;@@cont:
;    ; bx = si = p_str1, ax = di = p_str2
;    mov dx, di	; dx = p_str2
;    ; get string length of p_str2 (substring)
;
;    mov cx, ds
;    mov es, cx
;    xor ax, ax
;    mov cx, ax
;    dec cx	; cx = -1
;    repne scas BYTE PTR es:[di]
;    not cx
;    dec cx
;    ; ax=??00, bx=si=p_str1, dx=p_str2, di=after 0, cx = strlen(p_str2)
;    ; ERROR - out of registers
;    mov dx, bx	    ; dx = p_str2
;
;    mov bx, cx ;bx = len substring
;
;    mov cx, ss
;    mov es, cx
;
;    ; get string length of p_str1 (string)
;    mov di, [p_str1] ; es/ss:di = p_str1
;    mov cx, ax
;    dec cx
;    repne scas BYTE PTR es:[di]
;    not cx
;    dec cx
;
;    dec di
;    mov [p_temp], di ; p_temp = end of str1
;    xchg cx, bx
;    ; bx = len str1, cx= len str2
;    cmp cx, bx
;    jle @F
;    ; cannot be, substring longer than string
;    mov ax, di
;    jmp @@exit
;
;@@:
;    dec cx
;    ; bx = strlen(str1), cx=strlen(str2)
;    sub bx, cx
;    inc bx
;    ; bx = number of chars in str1 to check
;
;    mov di, [p_str2]	    ;es/ss:di = substring pointer
;    mov si, [p_str1]	    ; ds:si = string pointer
;    mov al, es:[di]	; first char of substring
;    ; match the first character
;@@loop:
;    mov ah, [si]	; ds:[si], next char of string
;    cmp al, ah
;    jne @@notequal
;    ; first chars are equal, maybe the rest of the string is also
;    ;	ds:[si] points to char in string, that is equal to first char in sub
;    ;	cx length of substring
;	push cx ; save substring strlength
;	push si ; save current pointer into string
;	repe cmps BYTE PTR ds:[si], es:[di]
;	jcxz @F     ; if cx==0, then MAY have found it
;	jmp @@notfoundit    ; cx != 0, then did NOT find it
;	@@:
;	jz @@foundit	    ; if (cx==0) and (last comparison was equal)
;@@notfoundit:
;	; not found
;	    pop si
;	    pop cx ; restore old pointer
;	    inc si
;	    mov di, [p_str2]	; restore pointer to substring
;	    mov al, es:[di]	; first char of substring
;	    dec bx
;	    jz @@done
;	    jmp @@loop
;@@foundit:
;	    ; found the string
;	    pop ax ; was push si
;	    pop cx ; restore old pointer
;	    jmp @@exit
;@@notequal:
;    dec bx
;    jz @@done
;    inc si
;    jmp @@loop
;
;@@done:
;    mov ax, WORD PTR [p_temp]
;@@exit:
;    ret
;@strstr ENDP
_TEXT ENDS
END
