#define ILIBC_64_EXTERN_PTRS 1
#include "ilibc_64.inc"

MAX_STRING_LENGTH==0XFFFFFFFF
// Conventions used:
//	IA-64 Software Conventions and Runtime Architecture Guide (Intel).
// Modifications to the convention:
//	To simplify assembly language interfacing.
//	None that "should" impact the callee.
//	None that "should" be incompatible with the C language.
//	Only scratch r28-r31 may possibly be altered by the library routine.
//	Only predicate p28-p31 may possibly be altered by the library.
//	r28-31 and p28-31 are not saved by the library routine.
//	r9-r11 are used as scratch registers, and values returned in r8.
//  although the assembly programmer will need to save a few scratch registers.
// All library procedures are independent.
//	Otherwise known as leaf procedures in intel documentation.
//	Do not call any other procedures.
//	The given register stack frame is not altered from default supplied by the br.call instruction (no alloc).
//	Never accesses global data area thru gp.
//	Never use stack. Stack is not altered, so sp is not saved or used.
//	The callee saves ar.pfs. (A convention requirement).


	.file	"mod1.S"
	.pred.safe_across_calls p1-p5,p16-p63
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(strlen)
#endif

.text
// strlen
// GIVEN:
//	p_str	pointer to string
// RETURNS:
//	int	string length of p_str
// NOTES:
//	uses r9, r32
p_str==r32	// in/out0
cnt==r8		// return value(return reg)
tmp==r9		// temp value (return scratch)

ilibc_64_proc_start(strlen)
//	.align 16
//	.global strlen#
//	.proc strlen#
//strlen:
//	.prologue PROLOGUE_SAVE_PSP, 31
//	.prologue
//	.vframe r31
//	mov r31 = r12
ilibc_64_proc_prologue
	;;
	.body
	mov cnt = r0
loop_1:
	ld1 tmp = [p_str]
	add cnt = cnt, r0, 1
	add p_str = p_str, r0, 1
	cmp.ne p30,p31 = r0, tmp
	(p30) br loop_1
	sub cnt = cnt, r0, 1
ilibc_64_proc_epilogue
//	.restore sp
//	mov r12 = r31
	br.ret.sptk.many b0
ilibc_64_proc_end(strlen)
//	.endp strlen#


























