INCLUDE CLIB_16.INC

;memcmp() -- Compare memory blocks
;int __far memcmp(const void __far * const, const void __far * const, const int);

_TEXT SEGMENT
memcmp	    PROC FAR16 C uses es ds si di,
		p_m1:FAR16 PTR, p_m2:FAR16 PTR, cnt:WORD

	    lds si, [p_m1]	    ;ds:SI = source
	    les di, [p_m2]	    ;es:DI = destination

	    xor ax, ax
	    mov cx, es
	    mov bx, ds
	    cmp cx, bx
	    jne @@cont
            cmp si,di               ;Equal?
	    je @@done
@@cont:

	    mov cx,[cnt]	   ;CX = count
	    repe cmpsb		    ;Compare memory
	    je @@done
	    dec si
	    dec di

	    lods BYTE PTR ds:[si]
	    mov ah, es:[di]
	    inc di
	    cmp ah, al
	    ja @@less
	    xor ax, ax
	    inc ax
	    jmp @@done
@@less:
	    xor ax, ax
	    dec ax
@@done:
	    ret
memcmp ENDP
_TEXT ENDS
END
