#include <stdio.h>
#include <graph.h>
#include "idpower.h"

/*
 * Simple program that displays what keys you are pushing down.
 * Also demonstrates on how to hook in your own keyboard handler.
 *
 * You can link this with either using the idllPower library or using the
 * powerExe linking system. (using dllPower loader)
 */

char *kBuff;
int   jScan;
int   jPress;

void myHandler(int scanCode, int pressed)
  {
  kBuff[scanCode] = (char)pressed; // Update the internal keyboard buffer
                                   // ourselves so the rest of the keyboard
                                   // functions work This is not required if
                                   // you have your own set of functions.

  jPress = pressed;            // save weather the key was pressed or not.
  jScan  = scanCode;           // save scanCode.
  }

int main()
  {
  idllHookKbd();

  setbuf(stdout, NULL);

  kBuff = idllGetKbdBuf();     // Get internal ketboard buffer.

  idllCustomKbdHook(myHandler);

  _clearscreen(_GCLEARSCREEN);
  printf("Keys pressed (0x%X, 0x%X): ", jScan, jPress);
  while (!idllKeyPressed(1)) /* Escape key */
     {
     if (idllKbdEvent()) // Has any key bees pressed or released?
        {
        _clearscreen(_GCLEARSCREEN);
        printf("Keys pressed (0x%X, 0x%X): ", jScan, jPress);
        for (int i=0;i<0x1FF;i++)
           {
           if (idllKeyPressed(i)) printf("Key[0x%X], ", i);
           //kBuff[i] would also work here
           }
        }
     }

  idllUnhookKbd();
  return 0;
  }

