/* examp3.c -> Trapezoidal integration examples */
/* Copyright in May of 2000, by Massago, Sadao - DM/UFSCar - Brazil */
/* Bug fixed by Aggod Jozsef <Aggod@freemail.hu> in november of 2000 */


#include <stdio.h>
#include "evallt.h"


#define STRBUFFLEN 100

int main()
{
  double x, I;  /* x, y are used to table example too */

  char expr[STRBUFFLEN];
  int j, m;
  double a, b, h;

  /* table making example */
  printf("integration (trapsezoidal rule) examples\n");

  /* getting the lower limit. will be an expression */
  do {
    printf("Enter the expression of lower limit: ");

    /* caution: scanf() does not clean the "\n" */
    do { /* use this loop, if using gets() after scanf() callings () */
      gets(expr); /* to read the expression, do not use scanf(), because
		   scanf() read only one words */
    } while(expr[0] == 0);


    if(Parse(expr) != SUCESS) {
      printf(" Error on parsing.\n");
      printf(" %s\n", ParseErrorMsg());
      printf(" %s\n", expr);
      printf(" %*s^\n", ParseErrorPos-1, "" );
    }
  } while(ErrorStatus != SUCESS);
  a = Eval();

  /* getting the upper limit. will be an expression */
  do {
    printf("Enter the expression of upper limit: ");

    /* caution: scanf() does not clean the "\n" */
    do { /* use this loop, if using gets() after scanf() callings () */
      gets(expr); /* to read the expression, do not use scanf(), because
		   scanf() read only one words */
    } while(expr[0] == 0);


    if(Parse(expr) != SUCESS) {
      printf(" Error on parsing.\n");
      printf(" %s\n", ParseErrorMsg());
      printf(" %s\n", expr);
      printf(" %*s^\n", ParseErrorPos-1, "" );
    }
  } while(ErrorStatus != SUCESS);
  b = Eval();

  /* getting the number of divisions. will be an expression */
  do {
    printf("Enter the expression of number of division: ");

    /* caution: scanf() does not clean the "\n" */
    do { /* use this loop, if using gets() after scanf() callings () */
      gets(expr); /* to read the expression, do not use scanf(), because
		   scanf() read only one words */
    } while(expr[0] == 0);


    if(Parse(expr) != SUCESS) {
      printf(" Error on parsing.\n");
      printf(" %s\n", ParseErrorMsg());
      printf(" %s\n", expr);
      printf(" %*s^\n", ParseErrorPos-1, "" );
    }
  } while(ErrorStatus != SUCESS);
  m = (int)Eval();

  if(m <= 0) {
    printf("\"m\" can not be negative or zero\n");
    return 1;
  }


  /* sharing with internal variables ... */
  if(!RegisterSharedVar("x", &x)) {
    printf("Error sharing \"x\" with internal variable x\n");
    return ERROR;
  }

  /* getting the function expression and parsing */

  do {

    printf("Enter expression of x: ");

    /* caution: scanf() does not clean the "\n" */
    do { /* use this loop, if using gets() after scanf() callings () */
      gets(expr); /* to read the expression, do not use scanf(), because
		   scanf() read only one words */
    } while(expr[0] == 0);


    printf("now parsing the expression %s\n", expr);
    if(Parse(expr) != SUCESS) {
      printf(" Error on parsing.\n");
      printf(" %s\n", ParseErrorMsg());
      printf(" %s\n", expr);
      printf(" %*s^\n", ParseErrorPos-1, "" );
    }
  } while(ErrorStatus != SUCESS);


  /* calculate the integral */
  h = (b-a)/m;
  x = a;
  I = Eval();
  /*  for(j=0; j<=(m-1); j++) { */
  for(j=0; j < (m-1); j++) {    /*  Jav. Aggod  2000.11.12.  */
    x += h;
    I += 2*Eval();
  }
  x = b;
  I += Eval();

  /* I *= h; */
  I *= ( h * .5 );    /*  Jav. Aggod  2000.11.12.  */


  /* print the result */
  printf("a= %f\n", a);
  printf("b= %f\n", b);
  printf("m= %d\n", m);
  printf("h= %f\n", h);
  printf("expression = %s\n", expr);

  printf("integral = %f\n", I);

  return 0;
}

/* end of examp3.c */
