/* evallt.h- parse/eval lite */
/* Parser/Evaluator Version 0.6 */
/* Copyright in May of 2000, by Massago, Sadao in ICMC - Brazil */

#ifndef _EVALLT_H_
#define _EVALLT_H_


#ifdef __cplusplus
  extern "C" {
#endif

#define TRUE   1
#define FALSE  0

#define ON  1
#define OFF 0

#define SUCESS 0
#define ERROR  1

/*****************************/
/* Variables manipulations   */
/*****************************/

/*------< Shared variables >---------*/

extern int RegisterSharedVar(char *name, double *var);
/* Share the internal C variable */

extern int DeleteSharedVar(char *name);
/* delete the shared variables */

extern int ClearSharedVars(void);
/* clear all internal variables */

/*---------< get the values of variables/constants >----------*/

extern int SetValue(char* name, double value);
/* it set value of variable, but not create it */

extern double GetValue(char* name);
/* For external use only. Not used by evaluator() */
/* Set ErrorStatus = NOTFOUND, if the name not exist */
/* Caution: It reset the error flags */

/********************************/
/*    identifier validation:    */
/* will use as variables name?? */
/********************************/

extern int isNewName(char *name);
/* Name validation. */

/********************************************/
/* Observations for matherror modifications */
/* if compile evallt with _TURBO_C_ defined */
/********************************************/
/*
#ifdef _TURBO_C_
extern int matherr(struct exception *e);
#endif
   this matherr skip the error message and assignate the error code in
   errno and return HUGE_VAL, when mathematicall error ocur in
   math's functions.
*/

/********************/
/* Parser/evaluator */
/********************/

extern int ErrorStatus; /* default is SUCESS */
extern int ParseErrorPos;


extern int Parse(char *expression);
/* Parse the expression */

extern double Eval(void);
/* Evaluate the parsed expression */

extern char *ParseErrorMsg(void);
/* Check for error */

/**************************************************/
/* new defined one parameter C internal functions */
/* will used outside of Parser/Evaluator          */
/**************************************************/
extern double deg(double);
extern double fac(double);
extern double rad(double);
extern double round(double);
extern double sqr(double);
extern double trunc(double);


#ifdef __cplusplus
  };
#endif

#endif /* ifndef _EVALLT_H_ */
/* end of evallt.h */
