
/* emsalloc.c  EOUE Project, 1997 by Michael Mangelsdorf */
/* THIS FILE IS PUBLIC DOMAIN.
   LEAVE THIS MESSAGE IN PLACE AS COURTESY TO THE AUTHOR */


#include <stdio.h>
#include <dos.h>
#include <fcntl.h>

typedef unsigned char byte;

/* Check to see whether EMS manager available.
   Return value 0 on success.
*/
byte testemm (void)
{
   unsigned f_handle;
   if (_dos_open("EMMXXXX0",O_RDONLY,&f_handle)) return 1;
   if ((ioctl(f_handle,0)&0x80)&&(ioctl(f_handle,7)&0xFF)) {
      _dos_close (f_handle);
      return 0;
   } else _dos_close (f_handle);
   return 1;
}


/* One page is 16k, 4 pages in sequence beginning at emsframebase.
   Normally independent, program switches 4 pages simultaneously
   for 64k bank switching.
   Failing function returns true.
*/
byte emsalloc (byte pages, byte *emsframebase, unsigned *emshandle) {
 union REGS r;
 byte result;
  r.h.ah=0x43; r.x.bx=pages; int86(0x67,&r,&r);
 *emshandle=r.x.dx;
  result=r.h.ah;
   /*get EMS page frame*/
  r.h.ah=0x41; int86(0x67,&r,&r);
  emsframebase=(byte *)MK_FP(r.x.bx,0);
 return result?1:0;
}


/* Change view through EMS-window to access different 64k block.
*/
void banksw (byte bank, unsigned emshandle) {
 union REGS r;
 byte i;
  r.h.ah=0x44; r.h.al=0; r.x.dx=emshandle;
  for (i=0;i<4;i++) {    /* four EMS-pages make up the EMS segment */
   r.x.bx=bank*4+i;
   int86(0x67,&r,&r);
  }
}


/* De-allocate EMS, true on failing.
*/
byte emsdealloc (unsigned emshandle) {
 union REGS r;
  r.x.dx=emshandle; r.h.ah=0x45; int86(0x67,&r,&r);
 return r.h.ah?1:0;
}


