/* ---------------- statbar.c -------------- */

#include "dflat.h"

short StatusBarProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	char *statusbar;
	switch (msg)	{
		case CREATE_WINDOW:
		case MOVE:
			SendMessage(wnd, CAPTURE_CLOCK, 0, 0);
			break;
		case KEYBOARD:
			if ((short)p1 == CTRL_F4)
				return TRUE;
			break;
		case PAINT:	
			if (!isVisible(wnd))
				break;
			statusbar = DFcalloc(1, WindowWidth(wnd)+1);
			memset(statusbar, ' ', WindowWidth(wnd));
			*(statusbar+WindowWidth(wnd)) = '\0';
			strncpy(statusbar+1, "F1=Help", 7);
			if (wnd->text)	{
				short len = min(strlen(wnd->text), WindowWidth(wnd)-17);
				if (len > 0)	{
					short off=(WindowWidth(wnd)-len)/2;
					strncpy(statusbar+off, wnd->text, len);
				}
			}
			if (wnd->TimePosted)
				*(statusbar+WindowWidth(wnd)-8) = '\0';
			SetStandardColor(wnd);
    	    PutWindowLine(wnd, statusbar, 0, 0);
			free(statusbar);
			return TRUE;
		case BORDER:
			return TRUE;
		case CLOCKTICK:
			SetStandardColor(wnd);
			PutWindowLine(wnd, (char *)p1, WindowWidth(wnd)-8, 0);
			wnd->TimePosted = TRUE;
			return TRUE;
		case CLOSE_WINDOW:
			SendMessage(NULL, RELEASE_CLOCK, 0, 0);
			break;
		default:
			break;
	}
	return BaseWndProc(STATUSBAR, wnd, msg, p1, p2);
}


