/* -- File:     line.h
   --
   -- Author:   Anthony Lander
   -- Date:     January 10, 1989.
   --
   -- Description:
   --           Function prototypes for LINE.C.  These let us use strong type
   --           checking when we compile -- very important for speedy program
   --           developement!



/* ------------------------------------------------------------------------ */
/*              Functions that RETURN lines of text                         */
/* ------------------------------------------------------------------------ */
struct _line *get_first_line(void);
struct _line *get_last_line(void);
struct _line *get_new_line(void);


/* ------------------------------------------------------------------------ */
/*                   Functions that ADD lines of text                       */
/* ------------------------------------------------------------------------ */
void insert_after_line(struct _line *, struct _line *);
void insert_before_line(struct _line *, struct _line *);


/* ------------------------------------------------------------------------ */
/*                  Functions that DELETE lines of text                     */
/* ------------------------------------------------------------------------ */
void delete_line(struct _line *);
void delete_all_lines(void);


/* ------------------------------------------------------------------------ */
/*                   Functions that MOVE lines of text                      */
/* ------------------------------------------------------------------------ */
void move_before_line(struct _line *, struct _line *);
void move_after_line(struct _line *, struct _line *);

