/* RSE.C -- a program to redirect standard error
 *
 * Written by Scott R. Houck
 *
 * This program will redirect standard error to standard output
so
 * that a program's standard error output can be sent to a file
 * using the redirection symbols '>' or '>>' on the command line.
 *
 * The syntax is:  RSE program [arguments]
 */

#include <stdio.h>
#include <io.h>
#include <process.h>

int main(argc, argv)
int argc;
char **argv;
{
     if (argv < 2)
          {
	  fprintf(stderr, "Usage: RSE program [arguments]\n");
          exit(1);
          }
     ++argv;
     dup2(fileno(stdout), fileno(stderr));
     return spawnvp(P_WAIT, *argv, argv);
}
