/********* Listing 1 *************************** DYNARRAY.HPP ********
*  dynarray.hpp  Copyright (C) 1990 by Tom Provenzano
* 
*  Header file for a dynamic array class allowing the size of 
*  an array to be increased or decreased at runtime.
* 
**********************************************************************

#ifndef DYNARRAYHPP
#define DYNARRAYHPP

#include <stdlib.h>
#include <generic.hpp>

#define gdynarray(type) name2(type,gdynarray)
#define gdynarraydeclare(type)                          \
struct gdynarray(type) : dynarray                       \
{                                                       \
  gdynarray(type)(unsigned n=1) : (n,sizeof(type)) {}   \
  type& operator[] (int i)                              \
    { return *((type *) pick(i)); }                     \
  type *operator&(void)                                 \
    { return (type *) address(); }                      \
};

class dynarray
{
  private:
    unsigned elements;      // number of elements in array
    unsigned elem_size;     // number bytes in an array element
    char *array;            // address of array buffer
    int err;                // class error flag
    int change_size( unsigned );// change array size
  public:
    dynarray( unsigned n = 1, unsigned elemsize = 1 );
    ~dynarray( void )        { free( array ); }
    int error( void )        { int x = err; err = 0; return x; }
    char *pick( int );
    char *address( void )    { return array; }
    unsigned size( void )    { return elements; }
    int& operator[]( int i ) { return *(int *) pick( i ); }
    int  *operator&( void )  { return  (int *) array; }
};
#endif