/*         .c                       freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
 return(       3.0*x*x  - 2.0*x - 5.0);
}
char  feq[] = "3.0*x**2 - 2.0*x - 5.0";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
 return(       6.0*x - 2.0);
}
char Dfeq[] = "6.0*x - 2.0";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);

double t;
double c = .5;
/*-------------------------------- PROGRAM ---------------------------------- */
 Pfunct      =  f;
 PfunctDeriv = Df;

 clrscrn();
 printf("  f : x-> %s\n\n", feq);
 printf(" Df : x-> %s\n\n",Dfeq);

 printf(" With c = %0.3lf, the equation of the tangent is :\n\n",c);
 printf("       Df(c) (x-c) + f(c) = ");
 eq_Tan(  c,
       (*Pfunct),
       (*PfunctDeriv)
       );
 printf("\n\n\n\n");
 getchar();

 clrscrn();
 printf(" Find PB, the length of the tangent from P to the y axis.\n\n");

 t = ((*PfunctDeriv)(c));
 printf(" P(%6.3lf, %6.3lf)         -> P(c, f(c))         \n", c, f(c));

 t = ((*Pfunct)(c)) - (((*PfunctDeriv)(c))*c);
 printf(" B(%6.3lf, %6.3lf)         -> B(0, f(c)-cDf(c))\n\n", 0.0, t);

 t = c * sqrt(1+pow(((*PfunctDeriv)(c)),2));
 printf(" PB = %6.3lf               -> c sqrt(1+(Df(c)**2))", t);

                         /* plot [xmin:xmax] [ymin:ymax] */
 gplt_TanPy   (-4,      /* xmin  */
                 4,      /* xmax  */
                -9,      /* ymin  */
                 2,      /* ymax  */
                 c,
               feq,
         (*Pfunct),
         (*PfunctDeriv)
               );

 printf("\n\n To see the result in Gnuplot (gp373w32.exe) :\n\n");
 printf("     * open the file f_Df.plt with Gnuplot.\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

