PROGRAM Raphson2;

{--------------------------------------------------------------------}
{                                                                   -}
{  Turbo Pascal Numerical Methods Toolbox                           -}
{-     (C) Copyright 1986 Borland International.                    -}
{-                                                                  -}
{-     Purpose: This sample program demonstrates the                -}
{-              Newton-Raphson algorithm.  This program is very     -}
{-              bare-boned; it contains no I/O checking.            -}
{-                                                                  -}
{-  Include Files: RAPHSON.INC         procedure Newton_Raphson     -}
{-                                                                  -}
{-       Version Date: 26 January 1987                              -}
{-                                                                  -}
{--------------------------------------------------------------------}

VAR
  InitGuess : Real;           { Initial approximation }
  Tolerance : Real;           { Tolerance in answer }
  Root, Value, Deriv : Real;  { Resulting roots and other info }
  Iter : Integer;             { Number of iterations to find root }
  MaxIter : Integer;          { Maximum number of iterations }
  Error : Byte;               { Error flag }
  OutFile : Text;             { Output file }


  {------- HERE IS THE FUNCTION ----------}
  FUNCTION TNTargetF(X : Real) : Real;
  BEGIN
    TNTargetF := -40.0+X*(1.0-Exp(-98.1/X))/(1.0+Exp(-98.1/X));
  END;                        { function TNTargetF }
  {---------------------------------------}

  {------- HERE IS THE DERIVATIVE --------}
  FUNCTION TNDerivF(X : Real) : Real;
  VAR EE : Real;
  BEGIN
    EE := Exp(-98.1/X);
    TNDerivF := (1.0-EE*(1.0+98.1/X))/(EE+1.0)+
                 98.1*EE*(EE-1.0)/(X*Sqr(EE+1.0));
  END;                        { function TNDerivF }
  {---------------------------------------}

  {$I RAPHSON.INC}            { Load procedure Raphson }

BEGIN                         { program Newton_Raphson }
  Write('Initial Approximation to the root: ');
  ReadLn(InitGuess);
  WriteLn;
  Write('Tolerance (> 0, suggested 1E-6): ');
  ReadLn(Tolerance);
  WriteLn;
  Write('Maximum number of iterations (>= 0, suggested 100): ');
  ReadLn(MaxIter);
  WriteLn;

  Newton_Raphson(InitGuess, Tolerance, MaxIter,
                 Root, Value, Deriv, Iter, Error);

  WriteLn;
  WriteLn('Error = ', Error);
  WriteLn('Number of iterations: ':30, Iter:3);
  WriteLn('Calculated root: ':30, Root);
  WriteLn('Value of the function':28);
  WriteLn('at the root: ':30, Value);
  WriteLn('Value of the derivative':28);
  WriteLn('of the function at the':28);
  WriteLn('calculated root: ':30, Deriv);
END.                          { program Newton_Raphson }
