@ECHO OFF
REM   Master Boot Sector Read
MBSR_.COM
if errorlevel 4 goto error4
if errorlevel 3 goto error3
if errorlevel 2 goto error2
if errorlevel 1 goto error1

IF "%1" == "" GOTO TheEnd
IF EXIST %1 DEL %1
REN MBS.BIN %1
GOTO TheEnd

:error1
ECHO MBSR.BAT: Error: unable to read master boot sector from hard disk. Maybe
ECHO you have an operating system or antivirus TSR which prevents programs
ECHO from reading the master boot sector; or maybe your hard drive is dead.
GOTO TheEnd

:error2
ECHO MBSR.BAT: Error: unable to open file MBS.BIN for writing. Maybe the
ECHO current directory is on a read-only or write-protected drive; or maybe
ECHO there is already a read-only or system file named MBS.BIN; or maybe
ECHO there is already a directory named MBS.BIN; or maybe there
ECHO are too many open files.
GOTO TheEnd

:error3
ECHO MBSR.BAT: Error: unable to write any data to file MBS.BIN.
ECHO Maybe the disk is full.
GOTO TheEnd

:error4
ECHO MBSR.BAT: Error: wrote some but not all data to file MBS.BIN.
ECHO Maybe the disk is full.
GOTO TheEnd


:TheEnd
