#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*       reaction scheme parser      */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


/*

  Reaction scheme:

   <side> <connector> <side>

  Side:

   <element> [ [ '+' <element> ]  '+' <element> ]

  Element:

   [ <number> '*' ] <identifier>

  Connector:

   "->" | '='

  Identifier:

   string with up to NAME_L ASCII characters 33-126 except '*', '+', '=' or '$'

*/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "globals.h"
#include "gep1.h"

int element( char *ptrN, int s, int r, int *tm,
             char (huge *mn)[NAME_L], int huge *stoi,
             int (huge *rs)[MAX_STEP][MAX_MOL], int *im  );
int side( char *ptrR, int s, int r, int *tm,
          char (huge *mn)[NAME_L], int huge *stoi,
          int(huge *rs)[MAX_STEP][MAX_MOL], int *im  );
int reaction( char *ptrReac, int r, int *tm,
              char (huge *mn)[NAME_L], int huge *stoi,
              int (huge *rs)[MAX_STEP][MAX_MOL], int *im,
              unsigned char *rvr );

#pragma alloc_text( CODE7, element, side, reaction )

int element( char *ptrN, int s, int r, int *tm,
             char (huge *mn)[NAME_L], int huge *stoi,
             int (huge *rs)[MAX_STEP][MAX_MOL], int *im  )
{
 char *ptrS, *ptrIni, *ptrB;
 int i, j, k, st, fl, intm;

 /* get the soicheiometry coefficient or assign it to 1 if none	*/
 if( strchr( ptrN, '*' ) != NULL )
 {
  sscanf( ptrN, "%d*", &st);
  ptrB = strchr(ptrN, '*' )+1;
 }
 else
 {
  st = 1;
  ptrB = ptrN;
 }

 /* if the soicheiometry coefficient is 0 signal error and ret.	*/
 if( !st ) return -1;
 /* or if the rest of the string is empty do the same			*/
 if( *ptrB=='\0' ) return -1;
 /* if there are more '*' in the string do the same again!		*/
 if( strchr( ptrB, '*' ) != NULL ) return -1;

 /* check if metabolite has been flagged with a '$'				*/
 if( ( *ptrB == '$' ) )
 {
  /* if so point past of it ...									*/
  ptrB++;
  /* and signal that it is a external metabolite				*/
  intm = 0;
 }
 /* if not, this is a internal metabolite						*/
 else intm = 1;

 /* if metabolite name is longer than max. allowed, truncate it	*/
 if( lstrlen( ptrB ) > NAME_L - 1 )
 {
  ptrB[NAME_L-1] = '\0';
  fl = 1;
 }
 else fl =0;

 /* is this metabolite already registered?						*/
 for( i=0; i<*tm; i++)
  if( ! lstrcmp( &mn[i][0], ptrB ) ) break;
 /* if not, do it and increase the number of total metabolites	*/
 if( i==*tm )
 {
  /* first check if we reached the maximum MAX_MET				*/
  if(*tm == MAX_MET) return -2;
  lstrcpy( &mn[i][0], ptrB );
  (*tm)++;
 }
 /* if this has been marked as external ignore other claims!	*/
 if ( ! intm ) im[i] = intm;
 /* store the stoicheiometry coefficient						*/
 stoi[i*MAX_MET + r] +=  s*st;
 /* look for the first empty position of rs[r]					*/
 for(j=0; (j<MAX_MOL) && ((*rs)[r][j]!=0) ; j++);
 /* now assign it and the following to the relevant metabolite	*/
 for(k=st; k>0; k--, j++)
  (*rs)[r][j] = s*(i+1);
 /* if string has been truncated, overwrite the '\0' w/ anything*/
 if( fl ) ptrB[NAME_L-1] = '~';
 return 0;
}

int side( char *ptrR, int s, int r, int *tm,
          char (huge *mn)[NAME_L], int huge *stoi,
          int(huge *rs)[MAX_STEP][MAX_MOL], int *im  )
{
 int i,len,fl;
 char *ptrIni, *ptrId;

 len = strlen( ptrR );
 ptrIni = ptrR;
 if( *ptrIni == '+' ) return -1;
 for (i=0;;i++)
 {
  ptrId = strtok( ptrR, "+" );
  if( ptrId == NULL ) break;
  if( *ptrId == '\0' ) return -1;
  if( fl = element( ptrId, s, r, tm, mn, stoi, rs, im ) ) return fl;
  do ptrR++; while (*ptrR != '\0');
  ptrR++;
  if( (int)( ptrR - ptrIni ) > len ) break;
  if( ( *ptrR == '\0' ) ) return -1;
 }
 return 0;
}

int reaction( char *ptrReac, int r, int *tm,
              char (huge *mn)[NAME_L], int huge *stoi,
              int (huge *rs)[MAX_STEP][MAX_MOL], int *im,
              unsigned char *rvr )
{
 int i,len, fl;
 char *ptrEle, *ptr;


 for(ptr=ptrReac; *ptr!='\0'; ptr++)					/* get rid of whitespace	*/
  if( (*ptr==' ') || (*ptr=='\t') )
  {
   lstrcpy( ptr, ptr+1 );
   ptr--;
  }

 len = strlen( ptrReac );
 ptrEle = ptrReac;
 for (i=0;i<len;i++,ptrEle++)							/*find the separator		*/
 {
  if( *ptrEle == '=' )									/* that can be a '='		*/
  {
   *ptrEle = '\0';
   ptrEle++;
   rvr[r] = 1;
   break;
  }
  if( ( *ptrEle == '-' ) && ( *(ptrEle+1) == '>') )		/* or a "->"				*/
  {
   *ptrEle = '\0';
   ptrEle += 2;
   rvr[r] = 0;
   break;
  }
 }
 if( i==len ) return -1;
 if( strchr( ptrEle, '=' ) != NULL ) return -1;
 for ( i=0, ptr=ptrEle; i<len; i++,ptr++ )
  if( ( *ptr == '-' ) && ( *(ptr+1) == '>') ) return -1;
 for( i=0; i<MAX_MET; i++ )
  stoi[i*MAX_MET + r] = 0;								/* reset this column		*/
 for( i=0; i<MAX_MOL; i++ )
  (*rs)[r][i] = 0;
 if( fl = side( ptrReac, -1, r, tm, mn, stoi, rs, im) ) return fl;
 if ( fl = side( ptrEle, 1, r, tm, mn, stoi, rs, im) ) return fl;
 return 0;
}
