/*------------------------------------------------------------------------------
**
**      MKBIN.C     -     example use of C data def.
**
**      This program demonstrates the use of a data definition created
**      by XED. The header "colours.hex" is used to rebuild an original
**      executable binary file. Note the use of the PARAGRAPHS, PARAGRAPH,
**      FILESIZE and BYTES_ON_LAST definitions found in colours.hex.
**
**
**      To compile:
**                      cl mkbin.c   (needs colours.hex)
**
**      Execute:        mkbin
**
**      The file 'colours.com' should be generated.
**
**----------------------------------------------------------------------------*/
#include <stdio.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "colours.hex"              // XED generated

const char *target = "colours.com";

int main ()
{
    int fd;
    unsigned long l, wrbytes = 0L;

    if ((fd = open (target, O_WRONLY|O_CREAT|O_TRUNC|O_BINARY,
        _S_IREAD | _S_IWRITE)) < 0)
    {
        fprintf (stderr, "can\'t open %s for writing\n", target);
        exit (1);
    }

    for (l = 0L; l < PARAGRAPHS; l++)
    {
        int bytestowrite = 16, byteswritten = 0;

#ifdef BYTES_ON_LAST
        if (l == PARAGRAPHS - 1L)
            bytestowrite = BYTES_ON_LAST;
#endif

        if ((byteswritten = write(fd, untitled[l].paragraph, bytestowrite)) < 0)
        {
            fprintf (stderr, "error writing %s\n", target);
            close (fd);
            exit (2);
        }
        wrbytes += byteswritten;
    }
    close (fd);

    if (wrbytes == FILESIZE)
        fprintf (stderr, "%lu bytes written to %s\n", FILESIZE, target);
    else
    {
        fprintf (stderr, "error: file sizes not consistent (%lu) %lu\n",
            FILESIZE, wrbytes);
        exit (3);
    }
    exit (0);
}

/* EOF: MKBIN.C --------------------------------------------------------------*/
