	title	MS Pascal ASM Support Package
;
; Assembler Routines for MS Pascal
; DLX Bulletin Board System V7.0
;
; FREEWARE NOTICE
;
; DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
; Anyone who wishes to may run the program, copy it, or modify it for
; any purpose, including commercial gain.
;
true		equ	1		; pascal t boolean
false		equ	0		; pascal f boolean
tick_len	equ	55		; milliseconds per bios timer tick
bmem		equ	12h		; bios memory size function
bkbd		equ	16h		; bios keyboard function
btod		equ	1ah		; bios time-of-day function
dos		equ	21h		; dos function call
		page
pushem	macro
	push	bp
	mov	bp,sp
	push	ds
	endm
popem	macro
	pop	ds
	pop	bp
	endm
		page
rbda		segment	at 40h
		org	49h
crt_mode	db	?		; current crt mode
		org	65h
crt_mode_set	db	?		; current setting of 3x8 register
rbda		ends
;
hirom	segment	at 0f000h
	org	0e000h
mfg	db	64 dup(?)	; manufacturer's copyright notice
	org	0fffeh
romid	db	?		; 0ffh=pc or old xt, 0feh=xt, 0fdh=jr, 0fch=at
hirom		ends
		page
data		segment	para public 'DATA'
clock0_lo	dw	0		; external clock origin
clock0_hi	dw	0		; (32 bit integer)
A440		dw	440		; nominal frequency
dw_mpd		dw	1000/10		; msecs per decisecond
dw_tick_len	dw	tick_len	; timer tick in msecs
dw1024		dw	1024		; size of a bios memory page
dw16		dw	16		; 2^4
old_date	dw	0		; month, day
old_time	dw	0		; hours, minutes
days		db	31,28,31,30,31,30,31,31,30,31,30,31	; days/month
filename	db	64 dup(0)	; asciz filename
filename2	db	64 dup(0)	; asciz filename for .BAK files
crlf		db	13,10		; carriage return, linefeed
eof_hi		dw	0		; file ptr
eof_lo		dw	0		; used by openz
buffer		db	0		; tiny buffer used by openz
data		ends
dgroup		group	data
		page

code	segment	para public 'CODE'
	assume	cs:code

	public	setcp			; set cursor position
	public	scrollup		; scroll window up
	public	clock_reset		; reset timer
	public	clock			; return deciseconds since clock_reset
	public	clock_raw		; return bios tick count (55 ms ticks)
	public	crit_on			; install critical error handler
	public	fix_date		; fix date rollover problem
	public	date_format		; get date format for current country
	public	init			; initialize this package
	public	vidbuf			; return segment of video buffer
	public	beep_on			; start beeping at given note
	public	beep_off		; stop beeping
	public	mail_open		; if file exists, append else create
	public	mail_zopen		; like mail_open, zaps Ctrl-Zs
	public	mail_writeln		; write a line to a file
	public	mail_close		; close file
	public	mail_delete		; delete file
	public	filesize		; return number of bytes in a file
	public	bak			; rename file to .BAK
	public	exist_dir		; is given path a valid directory?
	public	exist_file		; does given file exist?
	public	exist_wild		; does given wildcard spec exist?
	public	megs_free		; free megabytes on default disk
	public	movesl2			; block move for video buffers
	public	xopen			; open file for xmodem
	public	xread			; read block for xmodem
	public	xwrite			; write block for xmodem
	public	find_first		; find first matching file
	public	find_next		; find next matching file
	public	set_dta			; set disk transfer address

	page
;
; procedure setcp(row,col:byte);
;
; moves cursor according to row & col
;
	assume	ds:dgroup,es:nothing
setcp	proc	far
	pushem
	mov	ah,2		; set cursor position
	mov	dh,8[bp]	; row
	mov	dl,6[bp]	; column
	mov	bh,0		; first page
	int	10h		; bios display function
	popem
	ret	4		; done, pop two args
setcp	endp
	page
;
; procedure scrollup(ulc,lrc,attr,lines : integer);
;
; 12[bp] = ulc   = upper left corner (row,col)
; 10[bp] = lrc   = lower right corner (row,col)
; 8[bp]  = attr  = display attribute for cleared lines
; 6[bp]  = lines = number of lines to scroll
;
; includes fix for bad bios that won't scroll up a 1 line window
;
	assume	ds:dgroup,es:nothing
scrollup proc	far
	pushem
	mov	ah,6		; scroll up
	mov	al,6[bp]	; number of lines to scroll (0 = clear)
	mov	cx,12[bp]	; ulc
	mov	dx,10[bp]	; lrc
	cmp	ch,dh		; different rows?
	jne	su_1		; jump if so
	mov	al,0		; use just clear the row
su_1:	mov	bh,8[bp]	; display attribute for fills
	int	10h		; bios display function
	popem
	ret	8		; done, toss 4 args
scrollup endp
	page
;
; procedure clock_reset;
;
; reset clock origin
;
	assume	ds:dgroup,es:nothing
clock_reset proc far
	pushem

	mov	ah,0		; read clock
	int	btod		; bios time-of-day routine
	mov	clock0_hi,cx	; high portion of clock
	mov	clock0_lo,dx	; low portion of clock

	popem
	ret
clock_reset endp
	page
;
; function clock : integer;
;
; return time in deciseconds since clock_reset was called
;
	assume	ds:dgroup,es:nothing
clock	proc	far
	pushem

	mov	ah,0		; read clock
	int	btod		; bios time-of-day routine
	sub	dx,clock0_lo	; subtract old clock
	sbb	cx,clock0_hi	; result is 55 msec tick count
	mov	ax,dx		; prepare for mul/div
	mov	dx,cx		; ax=lo, dx=hi
	mul	dw_tick_len	; convert ticks
	div	dw_mpd		; to 100 msec ticks

	popem
	ret
clock	endp
	page
;
; function clock_raw : integer4;
;
; return bios clock in 55-msec ticks
;
	assume	ds:dgroup,es:nothing
clock_raw proc	far
	pushem

	mov	ah,0		; read clock
	int	btod		; bios time-of-day routine cx=hi, dx=lo
	mov	ax,dx		; ax=lo
	mov	dx,cx		; dx=hi

	popem
	ret
clock_raw endp
	page
;
; internal routine: critical error handler
;
	assume	ds:nothing,es:nothing
crit	proc	far
ahem	label	byte
	mov	al,0		; ignore or fail
	iret			; done
crit	endp
	page
;
; procedure crit_on;
; install our critical error handler
;
	assume	ds:dgroup,es:nothing
crit_on	proc	far
	pushem

; ignore if dos 2, fail if dos 3
	mov	ah,30h		; get dos version number
	int	dos		; dos 2 function
	cmp	al,3		; dos 3+?
	jae	co_1		; jump if not
	mov	cs:ahem+1,3	; change ignore to fail

; install our critical error handler
co_1:	mov	ah,25h		; set interrupt vector
	mov	al,24h		; critical error interrupt
	lea	dx,crit		; offset of our handler
	push	cs		; segment of
	pop	ds		; our handler
	int	dos		; dos 1 function

	popem
	ret			; done
crit_on	endp
	page
;
; procedure fix_date;
;
; fix date rollover problem -- call this before getting date
;
	assume	ds:dgroup,es:nothing
fix_date proc	far
	pushem

	cmp	old_date,0	; first time?
	jne	fd_1		; jump if not

; first time
	mov	ah,2ah		; get date
	int	dos		; dos 1 function
	mov	old_date,dx	; remember month and day
	mov	ah,2ch		; get time
	int	dos		; dos 1 function
	mov	old_time,cx	; remember time
	jmp	short fd_x	; exit

; compare time to old time and exit if later
fd_1:	mov	ah,2ch		; get time
	int	dos		; dos 1 function
	cmp	cx,old_time	; later or same time as before?
	mov	old_time,cx	; remember time
	jae	fd_x		; jump if later or same

; time is earlier, exit if date has rolled over properly
	mov	ah,2ah		; get date
	int	dos		; dos 1 function
	cmp	dx,old_date	; different month and/or date?
	mov	old_date,dx	; remember date
	jne	fd_x		; jump if new day

; it didn't roll over: get days in the current month
	mov	bl,dh		; get month to bl
	dec	bl		; convert to zero origin
	mov	bh,0		; bl -> bx
	mov	al,days[bx]	; get days in month
	cmp	bl,1		; february?
	jne	fd_2		; jump if not
	test	cl,11b		; is year divisible by four?
	jnz	fd_2		; jump if not
	inc	al		; adjust leap year

; increment date
fd_2:	inc	dl		; next day
	cmp	dl,al		; past end of month?
	jbe	fd_3		; jump if not
	mov	dl,1		; first day of
	inc	dh		; next month
	cmp	dh,12		; past end of year?
	jbe	fd_3		; jump if not
	mov	dh,1		; january of
	inc	cx		; next year

; set new date
fd_3:	mov	old_date,dx	; remember date
	mov	ah,2bh		; set date
	int	dos		; dos 1 function

fd_x:	popem
	ret			; done, no args
fix_date endp
	page
;
; function date_format : word;
;
; returns country info:  hibyte is data separator char,
;			 lobyte is date order:
;				0 = USA    = m d y
;				1 = Europe = d m y
;				2 = Japan  = y m d
date_format proc far
	push	bp			; save frame
	mov	bp,sp			; our frame
	mov	al,0			; get current country
	lea	dx,filename		; used as scratch buffer
	mov	ah,38h			; get country info
	int	dos			; dos 2 call
	jc	df_err			; jump if error
	mov	ah,30h			; get dos version number
	int	dos			; dos 2 function
	cmp	al,3			; dos 3+?
	mov	al,filename		; (date order)
	jb	df_2			; jump if not
; dos 3
	mov	ah,filename+11		; date separator available in dos 3
	jmp	short df_x		; done
; error
df_err:	mov	al,0			; default to USA
; dos 2
df_2:	mov	ah,'-'			; and slash
; finish up
df_x:	pop	bp			; restore frame
	ret	0			; done, no args
date_format endp
	page
;
; procedure init;
;
; initialize various global states of the machine
;
	assume	ds:dgroup,es:nothing
init	proc	far
	pushem
; verify off
	mov	ah,2eh		; set verify switch
	mov	dl,0		; required
	mov	al,0		; turn verify off
	int	dos		; dos 1 call
; break off
	mov	ah,33h		; set break switch
	mov	al,1		; set break
	mov	dl,0		; to off
	int	dos		; dos 1 call
; misc
	sti			; allow interrupts
	cld			; forward direction
	popem
	ret			; done, no args
init	endp
	page
;
; function vidbuf : word;
;
; determines segment of video buffers
; monochrome adapter is at B000
; color/graphics adaptor is at B800 (also old Compaqs)
;
	assume	ds:dgroup,es:nothing
vidbuf	proc	far
	pushem
	int	11h		; bios equipment determination
	and	al,00110000b	; isolate bits 5,4
	cmp	al,00110000b	; 11 means bw card
	je	vb1		; jump if bw card
	mov	ax,0b800h	; else color/graphics card
	jmp	short vbx	; finish
vb1:	mov	ax,0b000h	; indicate bw card
vbx:	popem
	ret			; done, no args
vidbuf	endp
	page
;
; procedure beep_on(freq : integer);
; a dvsr of 1331 corresponds to A-440
; a bigger divisor gives a lower note and vice versa
;
; start beeping from the speaker
;
	assume	ds:dgroup,es:nothing
beep_on	proc	far
	push	bp
	mov	bp,sp

	mov	al,0b6h		; timer mode binary etc.
	out	43h,al		; timer mode register

	mov	ax,1331
	mul	A440
	div	word ptr 6[bp]	; given frequency
	out	42h,al		; set lsb
	mov	al,ah		; set
	out	42h,al		;     msb

	in	al,61h		; get spkr control
	or	al,3		; enable spkr
	out	61h,al		; leave other bits unchanged

	pop	bp
	ret	2
beep_on	endp
	page
;
; procedure beep_off;
;
; stop beeping from the speaker
;
	assume	ds:dgroup,es:nothing
beep_off proc	far
	in	al,61h		; get spkr control
	and	al,11111100b	; turn off spkr
	out	61h,al		; leave other bits unchanged
	ret			; done, no args
beep_off endp
	page

; function mail_open(consts filename : lstring) : integer;

; if file exists
;   then open it for append
;   else create it
; returns file handle

; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
mail_open proc	far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; try to open the file
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	al,1		; write access
	mov	ah,3dh		; open a file
	int	dos		; dos 2 call
	jc	mo_1		; jump if error, i.e. doesn't exist
	mov	bx,ax		; file handle

; lseek to end
	mov	al,2		; move to eof
	mov	cx,0		; no
	mov	dx,0		;    offset
	mov	ah,42h		; lseek
	int	dos		; dos 2 call
	jc	mo_oops		; jump if error
	mov	ax,bx		; return file handle
	jmp	short mo_x	; done

; create the file
mo_1:	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	cx,0		; normal attribute
	mov	ah,3ch		; create a file
	int	dos		; dos 2 call
	jnc	mo_x		; jump if ok

; error handler
mo_oops:neg	ax		; error indicated by negative handle

mo_x:	popem
	ret	6		; done, toss 3 args
mail_open endp
	page

; function mail_zopen(consts filename : lstring) : integer;

; if file exists
;   then open it for append, zapping any Ctrl-Zs at end of file
;   else create it
; returns file handle

; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
mail_zopen proc	far
	pushem
	push	ds
	pop	es
	assume	ds:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; try to open the file
	mov	ah,3dh		; open a file
	mov	al,2		; read/write access
	mov	dx,offset dgroup:filename	; offset of asciz filename
	int	dos		; dos 2 call
	jc	mz_2		; if doesn't exist, create it
	mov	bx,ax		; file handle

; lseek to end
	mov	ah,42h		; lseek
	mov	al,2		; move to eof
	mov	cx,0		; no
	mov	dx,0		;    offset
	int	dos		; dos 2 call
	jc	mz_oops		; jump if error
	mov	eof_hi,dx	; note location
	mov	eof_lo,ax	; of eof

; back one
mz_1:	mov	ah,42h		; lseek
	mov	al,0		; absolute move
	mov	cx,eof_hi	; end
	mov	dx,eof_lo	; of file
	sub	dx,1		; minus
	sbb	cx,0		; another one
	mov	eof_hi,cx	; save
	mov	eof_lo,dx	; result
	int	dos		; dos 2 call
	jc	mz_oops		; abort on error

; read one byte
	mov	ah,3fh		; read
	mov	cx,1		; one byte
	mov	dx,offset dgroup:buffer	; read to here
	int	dos		; dos 2 call
	jc	mz_oops		; abort on error

; if ctrl-Z, then loop
	cmp	buffer,01ah	; ctrl-z?
	je	mz_1		; yup, zap that sucker

; else if LF, then done
	cmp	buffer,0ah	; linefeed?
	je	mz_ok		; great, all is well

; else append crlf
	mov	ah,40h		; write
	mov	cx,2		; two bytes
	mov	dx,offset dgroup:crlf		; carriage return, linefeed
	int	dos		; dos 2 call
	jc	mz_oops		; jump if error
	jmp	short mz_ok	; jump if ok

; create the file
mz_2:	mov	ah,3ch		; create a file
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	cx,0		; normal attribute
	int	dos		; dos 2 call
	jnc	mz_x		; jump if ok, handle in ax

; error handler
mz_oops:neg	ax		; error indicated by negative handle
	jmp	short mz_x	; done

; all is well, return handle of existing file
mz_ok:	mov	ax,bx		; return file handle

; done
mz_x:	popem
	ret	6		; done, toss 3 args
mail_zopen endp
	page

; procedure mail_writeln(handle : integer; consts msg : lstring);
; function mail_writeln(handle : integer; consts msg : lstring) : integer;

; write a line to a file handle
; function returns error code or 0 if no errors

; 12[bp] = file handle
; 10[bp] = max size
;  8[bp] = segment of msg
;  6[bp] = offset of msg

	assume	ds:dgroup,es:nothing
mail_writeln proc far
	pushem

; write msg
	mov	bx,12[bp]	; file handle
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to msg lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	jcxz	mw_1		; don't write if no bytes
	inc	si		; advance to first character of lstring

; write string
	mov	dx,si		; ds:dx points to string[1]
	mov	ah,40h		; write to file
	int	dos		; dos 2 call
	jnc	mw_1		; jump if no error
	pop	ds		; restore data segment
	jmp	short mw_err	; jump to error handler
mw_1:	pop	ds		; restore data segment
	assume	ds:dgroup

; write crlf
	mov	cx,2		; two bytes
	mov	dx,offset dgroup:crlf		; carriage return, linefeed
	mov	ah,40h		; write to file
	int	dos		; dos 2 call
	jc	mw_err		; jump if error

; done
	mov	ax,0		; no errors
mw_err:	popem
	ret	8		; done, toss 4 args
mail_writeln endp
	page

; procedure mail_close(handle : integer);

; close mail file

;  6[bp] = file handle

	assume	ds:dgroup,es:nothing
mail_close proc	far
	pushem

	mov	bx,6[bp]	; file handle
	mov	ah,3eh		; close a file handle
	int	dos		; dos 2 call

	popem
	ret	2		; done, toss 1 arg
mail_close endp
	page

; function mail_delete(consts filename : lstring) : integer;

; delete file

; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
mail_delete proc far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; delete the file
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	ah,41h		; delete a file
	int	dos		; dos 2 call

	popem
	ret	6		; done, toss 2 args
mail_delete endp
	page

; function filesize(consts filename : lstring) : integer4;

; if file exists
;   then return length in bytes
;   else return 0

; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
filesize proc	far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; try to open the file
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	al,0		; read access
	mov	ah,3dh		; open a file
	int	dos		; dos 2 call
	jc	fsz_1		; jump if error, i.e. doesn't exist

; determine length in bytes
	mov	bx,ax		; file handle
	mov	ah,42h		; Lseek
	mov	al,2		; to end of file
	mov	cx,0		; no offset
	mov	dx,0		; no offset
	int	dos		; dos 2 function

; close file
	push	ax		; save answer
	push	dx		; save answer
	mov	ah,3eh		; close a file handle
	int	dos		; dos 2 call
	pop	dx		; restore answer
	pop	ax		; restore answer
	jmp	short fsz_x	; finish up

; error handler
fsz_1:	mov	ax,0		; error indicated by zero time
	mov	dx,0		; integer4

fsz_x:	popem
	ret	6		; done, toss 3 args
filesize endp
	page

; function bak(consts filename : lstring) : boolean;

; rename file to .BAK

; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
bak	proc	far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; copy filename to local asciz string and add .BAK
	mov	di,offset dgroup:filename2	; offset of local asciz string
	push	ds		; save data segment
	mov	ax,8[bp]	; segment of filename lstring
	mov	ds,ax		; to data segment
	assume	ds:nothing
	mov	si,6[bp]	; offset of filename lstring
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	al,'.'		; tack
	stosb			;      on
	mov	al,'B'		;         .BAK
	stosb			; one
	mov	al,'A'		;     character
	stosb			;               at
	mov	al,'K'		;                  a
	stosb			;                    time
	mov	es:[di],cl	; end asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; rename the file
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	di,offset dgroup:filename2	; offset of .BAK version
	mov	ah,56h		; rename a file
	int	dos		; dos 2 call
	jc	bak_err		; jump if error

; done
	mov	ax,true		; all is well
	jmp	short bak_x	; done
bak_err:mov	ax,false	; negate error code
bak_x:	popem
	ret	6		; done, toss 3 args
bak	endp
	page

; function exist_dir (consts pathname : lstring) : boolean;

; does given path exist as a directory?

; 10[bp] = max size
;  8[bp] = segment of pathname
;  6[bp] = offset of pathname

	assume	ds:dgroup,es:nothing
exist_dir proc	far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy pathname to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; get file mode
	mov	ah,43h		; chmod
	mov	al,0		; return attribute
	mov	dx,offset dgroup:filename	; pathname in asciz form
	int	dos		; dos 2 function
	jc	ed_no		; error means file doesn't exist
	test	cx,10h		; subdirectory?
	jz	ed_no		; jump if not a subdirectory
	mov	ax,true		; else got a goodie
	jmp	short ed_x	; out

; error
ed_no:	mov	ax,false	; doesn't exist or not a directory

; done
ed_x:	popem
	ret	6		; done, toss 3 args
exist_dir endp
	page

; function exist_file(consts pathname : lstring) : boolean

; does file exist?

; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
exist_file proc	far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; try to find the file's mode
	mov	ah,43h		; change/find file mode
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	al,0		; find mode
	int	dos		; dos call
	jc	ef_1		; jump if error, i.e. doesn't exist

; file exists
	mov	ax,true		; file was found to exist
	jmp	short ef_x	; done

; file does not exist
ef_1:	mov	ax,false	; file was not found

; done
ef_x:	popem
	ret	6		; done, toss 3 args
exist_file endp
	page

; function exist_wild(consts pathname : lstring) : boolean

; does wildcard spec exist?

; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
exist_wild proc	far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds		; save data segment
	lds	si,6[bp]	; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]	; length byte to cl
	mov	ch,0		; cl -> cx
	inc	si		; advance to first character of lstring
	cld			; forward direction
	rep	movsb		; copy string
	mov	es:[di],cl	; ends asciz string
	pop	ds		; restore data segment
	assume	ds:dgroup

; find first matching file
	mov	ah,4eh		; find first file
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	cx,0		; normal files only
	int	dos		; dos 2 call
	jc	ew_1		; jump if error, i.e. doesn't exist

; file exists
	mov	ax,true		; file was found to exist
	jmp	short ew_x	; done

; file does not exist
ew_1:	mov	ax,false	; file was not found

; done
ew_x:	popem
	ret	6		; done, toss 3 args
exist_wild endp
	page

; function megs_free(drive : integer) : integer;

; returns number of free megabytes on specified drive
; returns -1 if error

	assume	ds:dgroup,es:nothing
megs_free proc far
	pushem
	mov	ah,36h		; get free disk space
	mov	dl,6[bp]	; specified drive
	int	dos		; dos function call
	cmp	ax,0ffffh	; bad drive?
	jne	mf_1		; jump if ok
mf_err:	mov	ax,0		; no megs free
	jmp	short mf_x	; and out
; ax = sectors/cluster
; bx = number of available clusters
; cx = bytes/sector
mf_1:	mul	bx		; dx:ax = number of available sectors
	mov	bx,dx		; save upper half in bx
	mul	cx		; dx:ax = low order part of 48-bit product
	mov	ax,bx		; toss bottom half
	mov	bx,dx		; save upper half
	mul	cx		; dx:ax = high order part of 48-bit product
	add	ax,bx		; add upper half of low order part
	adc	dx,0		; propagate the carry
	test	dx,0fff0h	; really big disk?
	jnz	mf_big		; jump if so
	mov	cl,4		; shift dx:ax right 4 bits
	shr	ax,cl
	mov	cl,12
	shl	dx,cl
	or	ax,dx		; this gives number of megabytes
	jmp	short mf_x
mf_big:	mov	ax,0ffffh	; maxint
mf_x:	popem
	ret	2		; done, one arg
megs_free endp
	page
;
; procedure movesl2(s,d : adsmem; n : word);
;
; 14[bp] = segment of s
; 12[bp] = offset of s
; 10[bp] = segment of d
;  8[bp] = offset of d
;  6[bp] = n
;
	assume	ds:nothing,es:nothing
movesl2	proc	far
	push	bp		; old frame
	mov	bp,sp		; new frame
	push	si		; save these
	push	di		; for C
	mov	cx,6[bp]	; get count
	jcxz	msl2_x		; done if zero
; copying loop
	push	ds		; save ds
	les	di,8[bp]	; destination pointer
	lds	si,12[bp]	; source pointer
	cld			; forward direction
msl2_1:	movsb			; move one byte
	inc	di		; skip attribute
	loop	msl2_1		; block move loop
	pop	ds		; restore ds
; done
msl2_x:	pop	di		; restore these
	pop	si		; for C
	pop	bp		; old frame
	ret	10		; done, toss 5 args
movesl2	endp
	page

; function xopen(ac : byte; consts filename : lstring) : integer;

; if file exists
;   then open it
;   else create it if not read access only
; returns handle or negative error number

; 12[bp] = access code (0=read 1=write 2=both)
; 10[bp] = max size
;  8[bp] = segment of filename
;  6[bp] = offset of filename

	assume	ds:dgroup,es:nothing
xopen	proc	far
	pushem
	push	ds
	pop	es
	assume	es:dgroup

; copy filename to local asciz string
	mov	di,offset dgroup:filename	; offset of local asciz string
	push	ds			; save data segment
	lds	si,6[bp]		; get ptr to filename lstring
	assume	ds:nothing
	mov	cl,ds:[si]		; length byte to cl
	mov	ch,0			; cl -> cx
	inc	si			; advance to 1st character of lstring
	cld				; forward direction
	rep	movsb			; copy string
	mov	es:[di],cl		; ends asciz string
	pop	ds			; restore data segment
	assume	ds:dgroup

; try to open the file
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	al,12[bp]		; access code
	mov	ah,3dh			; open file
	int	dos			; dos 2 call
	jnc	xo_x			; done if no errors

; else create if allowed
	cmp	byte ptr 12[bp],0	; read access?
	je	xo_oops			; error if so
	mov	dx,offset dgroup:filename	; offset of asciz filename
	mov	cx,0			; normal attribute
	mov	ah,3ch			; create file
	int	dos			; dos 2 call
	jnc	xo_x			; done if no errors

; error handler
xo_oops:neg	ax			; error indicated by negative handle

; done
xo_x:	popem
	ret	8			; done, toss 4 args
xopen	endp
	page

; function xread(handle : integer; msg : adsmem; n : word) : integer;

; read a given number of bytes from a file handle
; returns number of bytes read or negative error code

; 12[bp] = file handle
; 10[bp] = segment of msg
;  8[bp] = offset of msg
;  6[bp] = number of bytes to read

	assume	ds:dgroup,es:nothing
xread	proc far
	pushem

; get msg length
	mov	cx,6[bp];	; bytes to read
	jcxz	xr_2		; don't read if no bytes

; point to buffer
	mov	bx,12[bp]	; file handle
	push	ds		; save data segment
	lds	dx,8[bp]	; get ptr to target buffer
	assume	ds:nothing

; read string
	mov	ah,3fh		; read from handle
	int	dos		; dos 2 call
	jnc	xr_1		; jump if no error
	neg	ax		; error codes are negative

; finish up
xr_1:	pop	ds		; restore data segment
	assume	ds:dgroup
xr_2:	popem
	ret	8		; done, toss 4 args
xread	endp
	page

; function xwrite(handle : integer; consts msg : lstring) : integer;

; write a given number of bytes to a file handle
; returns number of bytes written or negative error code

; 12[bp] = file handle
; 10[bp] = segment of msg
;  8[bp] = offset of msg
;  6[bp] = number of bytes to write

	assume	ds:dgroup,es:nothing
xwrite	proc far
	pushem

; get msg length
	mov	cx,6[bp];	; bytes to write
	jcxz	xw_2		; don't write if no bytes

; point to buffer
	mov	bx,12[bp]	; file handle
	push	ds		; save data segment
	lds	dx,8[bp]	; get ptr to data buffer
	assume	ds:nothing

; write string
	mov	ah,40h		; write to handle
	int	dos		; dos 2 call
	jnc	xw_1		; jump if no error
	neg	ax		; error codes are negative

; finish up
xw_1:	pop	ds		; restore data segment
	assume	ds:dgroup
xw_2:	popem
	ret	8		; done, toss 4 args
xwrite	endp
	page
;
; function find_first(path,attr : word) : byte;
;
; path at 8[bp]
; attr at 6[bp]
;
find_first proc	far
	push	bp			; save old frame
	mov	bp,sp			; set new frame
	mov	ah,4eh			; find first matching file
	mov	dx,8[bp]		; offset of pathname
	mov	cx,6[bp]		; attribute to use in search
	int	dos			; dos 2 function
	jc	ff_x			; jump if error
	mov	ax,0			; else clear acc
ff_x:	pop	bp			; restore old frame
	ret	4			; done, toss 2 args
find_first endp
;
; function find_next : byte;
;
find_next proc	far
	push	bp			; save old frame
	mov	bp,sp			; our frame
	mov	ah,4fh			; find next matching file
	int	dos			; dos 2 function
	jc	fn_x			; jump if error
	mov	ax,0			; else clear acc
fn_x:	pop	bp			; restore old frame
	ret				; done, no args
find_next endp
	page
;
; procedure set_dta(dta : adsmem);
;
; 8[bp] = segment of dta
; 6[bp] = offset of dta
;
set_dta	proc	far
	push	bp			; save frame
	mov	bp,sp			; our frame
	push	ds			; save data segment
	mov	ah,1ah			; set disk transfer address
	lds	dx,6[bp]		; desired segment:offset in ds:dx
	int	dos			; dos 1 function
	pop	ds			; restore data segment
	pop	bp			; restore frame
	ret	4			; done, toss 2 args
set_dta	endp

code	ends
	end
