TEST(1V)		BATCH UTILITIES			TEST(1V)

NAME
	test - returns true or false according to a conditional
	expression.

AUTHOR
        Jason Mathews
	NASA/Goddard Space Flight Center
	<mathews@nssdca.gsfc.nasa.gov>

CATEGORY
	MS-DOS Batch utility - test file/directory status

SYNOPSIS
	syntax:  test <expression>

DESCRIPTION
	test evaluates the expression <expression> and, if its value
	is true, returns a non-zero (true) exit status; otherwise, a
	zero (false) exit status is returned.  test returns a
	zero if there are no arguments.

USAGE

 The following primitives are used to construct an expression.

 primitive operators testing one file:

      -f|b|c|e|d|s|z|r|w|x filename

   -e  true if filename exists
   -b  true if filename exists and is a block special device
   -c  true if filename exists and is a character special device
   -d  true if filename exists and is a directory
   -f  true if filename exists and is a regular file
   -s  true if filename exists and has a size greater than zero
   -z  true if filename exists and has a zero length (empty)
   -r  true if filename exists and is readable
   -w  true if filename exists and is writable
   -x  true if filename exists and is executable
	(MS-DOS: file extension = .COM, .EXE, .BAT, or .BTM )

   -m[n] filename
      True if filename exists and has been modified in n days (default=1).

 primitive operators comparing two files:

      -D|N|S file1 file2

   -D  true of file1 has same date as file2 and both files exist
   -N  true if file1 is newer than file2 and both files exist
   -S  true if file1 has same size as file2 and both files exist

 Logical operators:

 The above primitives may be combined with the following operators:

  cond1 [-a] cond2  True if both cond1 and cond2 are true.
		    The -a is not required.  It is implied by
		    the juxtaposition by the two conditions.

  cond1 -o cond2    True if either cond1 or cond2 is true
		    (-o is the OR operator).

  ! condition       True if the condition is false
		    (! is the unary NOT operator).

 AND/OR/NOT operators are processed left to right with no precedence;
 e.g. "! c1 -o c2 -a c3" is evaluated as (!c1 -o c2) -a c3.

  return errorlevel = 1 if the tested expression is true
  otherwise return 0 (conditions not meet or error flag set).

EXAMPLES

Test if c:\dos directory exists and autoexec.bat has been modified
within last 7 days.

	test -d c:\dos -m7 autoexec.bat

Test if image.dat has been modified today, in which case we
want to skip the update section.

	test -m image.dat
	if errorlevel 1 goto skip_update
	... update_file_here ...
	:skip_update
	...

Test if file has zero length or file has write access.

	test -z myfile -o -w myfile


MS-DOS Release 1.3    Last Change: 14 April 1994
