CR	EQU	0DH
LF	EQU	0AH

;v1.3
; -	Build entire graphics message in a buffer.
;	Then shift screen rows left one char, 8 rows at a time
;	Requires direct screen memory writes.
; -	First trying direct screen writes rather than BIOS calls.
; -	Ok, writes fine for one line.  Now have to make it scroll
;	horizontally.

;v1.2
; -	Tweaking to read banner in from StdIn.
; -	Expanding to handle more than 10 chars.
;	Ignores CR/LF.
;	Will halt on Ascii 0 or ^Z.
; -	Using BIOS TTY char display rather than DOS

;v1.1
; -	Additional comments (hastily), reformatting, and small patching by 
;David Kirschbaum
;Toad Hall
;kirsch@braggvax.ARPA

CSEG	SEGMENT
	ASSUME	CS:CSEG, DS:CSEG

	ORG	100H

BigEcho:
	jmp	Begin
;---------------------------
buff	label	byte
	db CR,'BIGECHO, Vers. 1.3 copyright by R.M.Wilson and B. Simon, 1986'
	db CR,LF
	db 'Usage: BIGECHO message /FB',CR,LF
	db "Here 'message' is a string of at most 10 characters,"
	db ' F and B are characters',CR,LF
	db 'for the foreground and background'
	db ' (defaults to blank and solid, i.e. / [ ).',26
BUFFEND	equ	($ - offset buff) + 50	;room for 50 msg chars

holdptr	dw	offset hold	;start at graphics buffer start		v1.2
holdend	dw	offset hold	;init end to start			v1.2

;---------------------------
Begin:
	call	Read_Text	;read StdIn into text buffer

	mov	al,1		;assume failure, ERRORLEVEL 1
	jb	Terminate	;read failed or 0 input

	call	ClrScr		;clear upper screen

	xor	dx,dx		;home cursor				v1.2
	call	Psn_Cursor

	call	Read_ROM	;read in, process ROM graphic char matrices

	mov	ax,0B000H	;mono screen seg
	mov	ES,ax
	ASSUME	DS:CSEG,ES:NOTHING

;Loop here until any keypress

Msg_Lup:

	call	Display_Msg	;display msg
	
	mov	cx,80		;move screen 80 cols left
TestLup:
	call	Scroll_Left
	loop	TestLup

	call	Chk_Kbd		;any key aborts
	jz	Msg_Lup		;no key, redisplay msg

	mov	ax,CS		;neaten up
	mov	ES,ax
	ASSUME	DS:CSEG,ES:CSEG

	mov	dx,1700H	;row 24, col 1
	call	Psn_Cursor

	xor	ax,ax		;ERRORLEVEL 0

Terminate:
	mov	ah,4CH		;terminate properly			v1.2
	int	21H		;					v1.2


;v1.2 Read desired text in from StdIn
Read_Text	proc	near

	ASSUME	DS:CSEG,ES:CSEG

	mov	dx,offset buff	;input buffer
	mov	cx,50		;max chars we'll read (for now)
	xor	bx,bx		;from StdIn
	mov	ah,3FH		;read from file/device
	int	21H
	jb	Read_Failed	;read failed, forget it
	mov	cx,ax		;amt read into CX
	jcxz	Read_Failed	;nothing read, forget it

	mov	si,dx		;from buff (start at base)
	mov	di,dx		;to buff (start at base)

Lod1:
	call	GetChar		;snarf, check next buff char
	jz	Over1		;must be EOF

	cmp	al,CR		;msg end yet?
	jz	Lod2		;Ignore CRs
	cmp	al,LF		;LF?
	jz	Lod2		;yep, ignore LFs
	 stosb			;normal char .. stuff it
Lod2:	loop	Lod1		;loop for all buff chars

Over1:	xor	ax,ax		;terminate text with AsciiZ 0
	stosb			;(also clears CF)
	ret

Read_Failed:
	stc			;return CF set for read failure
	ret

Read_Text	endp


;v1.1
;Snarf, process next buff char (from StdIn)
;Return ZF set (JZ nochar) if none avail or EOF/end of buffer
;Else AL = char

GetChar	proc	near
	ASSUME	DS:CSEG,ES:CSEG

	jcxz	BuffDone	;hit buffer end, forget it

	lodsb			;snarf next buff char
	or	al,al		;set ZF per char (should be non-zero)
	jz	NoChar		;zero char .. sigh
	cmp	al,1AH		;Ctrl Z?
	jnz	NoChar		;nope, it's ok

BuffDone:
	 xor	al,al		;return 0, ZF clear
NoChar:
	ret			;with ZF set per char
				;AL = char (if any)
GetChar	endp


;Read in graphic char matrices from ROM table

Read_ROM	proc	near

	mov	dx,0FA6EH	;Point DS:SI to table in ROM with dot	v1.1
				;(keep ROM table offset in DX as constant)
	mov	ax,0F000H	;patterns for ASCII characters 0..127
	mov	DS,ax
	ASSUME	DS:NOTHING,ES:CSEG	;DS = ROM

	mov	di,offset hold	;ES:DI target=80H-byte buffer
	mov	cx,50*4		;50 8-byte graphic char matrices
	xor	ax,ax		;init to 0
	rep	stosw
	mov	di,offset hold	;back to start again

	mov	bx,offset buff	;read text from here
	xor	ch,ch		;clear msb

FormLup:
	mov	al,CS:[bx]	;Load byte of message text.
	or	al,al		;end of msg?				v1.1
	jz	Go_on		;yep, skip

	xor	ah,ah		;assume no parms, clear msb
	shl	ax,1		;*2
	shl	ax,1		;*4
	shl	ax,1		;*8 for char matrix
	mov	si,dx		;point SI to ROM table base		v1.1
	add	si,ax		;bump to the char desired
	mov	cl,4		;8 chars in the screen matrix		v1.1
	rep	movsw		;get 8 bytes from ROM			v1.1
	inc	bx		;bump text char ptr
	cmp	bx,BUFFEND	;max 50 chars for now			v1.1
	jna	FormLup		; nope, loop for next cmd line char

;finished cmd line or hit switch char
Go_on:	mov	ax,CS
	mov	DS,ax
	ASSUME	DS:CSEG,ES:CSEG

	mov	holdend,di	;remember end of graphic hold buffer	v1.1
	ret

Read_ROM	endp


;Actual display process
Display_Msg	proc	near

;	mov	ax,0B000H	;mono screen seg
;	mov	ES,ax
	ASSUME	DS:CSEG,ES:NOTHING	;video seg

	mov	holdptr,offset hold	;back to buffer start
	mov	bh,80H		;handy constant				v1.2

;We loop here for each 10-character line (screenful)

Output:

	xor	bp,bp		;vertical row counter

;Loop to paint screen-width of characters
;(one loop per screen line)
Loop1:
	mov	cx,bp		;current row
	mov	ax,80 SHL 1
	mul	cl
	mov	di,ax		;screen pointer

	mov	si,holdptr	;ptr into graphics char hold buffer
				;(starts at hold base,
				; bumped each screenfull)
	add	si,bp		;vertical offset (row)
	mov	cl,10		;10 chars per screen

;Loop to display a screen-width (one row) of characters
Loop2:
	lodsb			;snarf the next graphics msg char
	mov	bl,bh	;80H	;8-bit counter
	mov	dl,al		;save char in DL for Loop3 refreshing	v1.2
	mov	al,0DBH		;solid block				v1.3

;Loop to display one row, one character
Loop3:
	test	dl,bl		;blank background?			v1.3
	mov	ah,70H		;assume inverse (black)			1.3
	jz	Over4		; yep
	 mov	ah,7		;make it normal				v1.2
Over4:
	stosw			;stuff AL char, AH attrib to screen	v1.3
	ror	bl,1		;rotate the 8-bit
	jnb	Loop3		;(8-bit wrapping back to 80H sets CF)

	add	si,7		;space between chars
	mov	ah,70H		;blank between chars
	stosw
	loop	Loop2		;for 10 cmd line chars

NextRow:
;vertical chars
	inc	bp		;vertical rows
	cmp	bp,8		;big chars 8 rows high?
	jb	Loop1		; not yet

;Full screen of 10 chars is done
;Gotta bump the hold buffer ptr
	mov	ax,holdptr
	add	ax,80		;10 graphic chars, 8 bytes each
	mov	holdptr,ax	;update ptr
	cmp	ax,holdend	;done?
	jb	Output		;nope, keep displaying

	ret

Display_Msg	endp


;v1.3	Gotta shift 8 rows left one char (starting at screen base for now)

Scroll_Left	proc	near

	push	cx		;save some regs
	push	DS		;save DS

	mov	ax,ES	;0B000H	;mono screen seg
	mov	DS,ax		;into DS
	ASSUME	DS:NOTHING,ES:NOTHING

	mov	dl,8		;handy counter for 8 rows
	mov	bx,2		;constant for bumping
	mov	si,bx	;2	;from line 0 col 1
	xor	di,di		;  to line 0 col 0

Scroll_Lup:
	mov	cx,79		;80 cols - 1
	rep	movsw		;move over as words
	dec	dl		;down a row
	jz	Scrolled_Left	;done

;SI -> first char, next row
;DI -> last char, this row
	add	si,bx	;2	;next row col 1
	add	di,bx	;2	;next row col 0
	jmp	Scroll_Lup	;keep going

Scrolled_Left:
	pop	DS		;restore DS
	pop	cx
	ret

Scroll_Left	endp


;Clear portion of screen

ClrScr	proc	near

	xor	cx,cx		;upper left col 0 row 0
	mov	dx,(22 SHL 8) + 79	;lower right
	mov	bh,7		;BH=normal attribute
	mov	ax,0600H	;scroll window up 0 lines (blank it)
	int	10H		;via BIOS
	ret

ClrScr	endp


;Enter with desired cursor psn in DX
;Assumes video Page 0 for now

Psn_Cursor	proc	near

	xor	bx,bx		;assume video Page 0 for now		v1.2
	mov	ah,2		;set cursor psn				v1.2
	int	10H		;via BIOS				v1.2
	ret

Psn_Cursor	endp


;Checks for keyboard status
;Returns ZF clear (no key), or set (key)
;If keypressed, gobbles and discards the key.

Chk_Kbd	proc	near

	mov	ah,1		;get kbd status
	int	16H		;via BIOS
	jz	Chk_KbdX	;nothing (JZ nokey)
	 xor	ah,ah		;read, discard that key
	 int	16H
	 or	ax,ax		;should set ZF (JNZ gotkey)
Chk_KbdX:
	ret

Chk_Kbd	endp


hold	label	byte		;Will hold the 8 bytes describing each
				; of n characters.

CSEG	ENDS
	END	BigEcho
