'PROGRAM - BONUS.BAS

'This program demonstrates a way to save room
'in the DGROUP by storing string data outside of
'the program, but within the file.

DECLARE FUNCTION GetSizeOfFile& _
						 (FileNumber AS INTEGER)

'Initialize and read the data

CLS								'Use the filename of
OPEN "I", 1, "NEWTEST.EXE"	'  this program
Size& = GetSizeOfFile&(1)	'Retrieve program LEN
InitLoc& = Size& + 1			'Set beginning data 
SEEK #1, InitLoc&				'  location to 1 past
									'  end of EXE portion
LINE INPUT #1, ID$			'Get the first variable
IDLen% = LEN(ID$) + 2		'Set the field length
									'  plus cr/lf
CtrPos& = InitLoc& + IDLen%	'Calculate position
LINE INPUT #1, Counter$			'Get next variable
CtrLen% = LEN(Counter$)			'Calculate its LEN
Counter% = VAL(Counter$) + 1	'Increment value
Counter$ = RIGHT$("   " + STR$(Counter%), CtrLen%)

'Display the data read from the end of the file

PRINT "Identification: "; ID$
PRINT "Number of times executed: "; Counter%

CLOSE 1		'Close file so we can reopen it and
				'  write data

OPEN "B", 1, "NEWTEST.EXE"		'Use binary mode
PUT 1, CtrPos&, Counter$		'Rewrite new value
CLOSE 1								'Close file again
END

FUNCTION GetSizeOfFile& (FileNumber AS INTEGER)

'This function returns the actual size of 
'programs in a long variable.  Pass the routine
'the file number used to open the file

'Read 1st 6 bytes of hdr
   A$ = INPUT$(6, FileNumber)
'Calculate the number of partial pages used in
'  the program file, if any.  This number is stored
'  in bytes 3 and 4.
   Fraction& = ASC(MID$(A$, 4)) * 256& _
                + ASC(MID$(A$, 3))
'Calculate the number of whole pages used to 
'  store the file.                
   Pages& = ASC(MID$(A$, 6)) * 256& _
             + ASC(MID$(A$, 5))
'If there are any fractional pages subtract 1
'  from the pages count.
   IF Fraction& THEN Pages& = Pages& - 1
'Each page is 512 bytes long so multiply 512
'  times the number of pages and add any
'  fractional bytes to the total.
   GetSizeOfFile& = Pages& * 512& + Fraction&
END FUNCTION
