;FONTSUB function to change fonts within a drawing.
;Intended to be used with RUN LISP (See RUNLISP.TXT)
;to automatically substitute fonts in multiple drawings,
;but can be used alone.

;Released into the public domain the the author, Sierra Hermitage
;
;Sierra Hermitage
;Rod Young, programmer
;140 Mesa Vista Drive
;Bishop, CA  93514
;Phone 619-387-2479 (voice)   619-387-2488 (data/fax, seldom enabled)
;E-mail hermit1@ix.netcom.com
;
;
;Scenario:
;
;1)	You need to ship out drawings that use proprietary fonts
;		and the receiving party does not have those fonts so you
;		need to substitute for fonts that they have.
;
;2)	You decide to change the 'look' of all of your drawings by
;		using different font sets and want all of your old drawings
;		to be changed to conform.
;
;3)	You receive drawings that use fonts other than the ones
;		you want (or have) and don't want to have to go through the
;		the dialog for each one in each drawing.
;
;4)	You use a simple font during drawing creation to speed up
;		regenerations but want to plot with a complex font.  In
;		which case you might add this routine to an automated plotting
;		program (See BATCH PLOT or RUN LISP).
;
;Directions:
;
;Create a text file with one line for each font substitution in
;the following format:
;
;oldfont newfont factor
;
;Omit 'factor' if there is no size difference between the two
;fonts.  Factor is the ratio of the old to the new.  One space
;only between oldfont,newfont and factor.
;
;Name this text file FONTSUB.TXT and place it in the same
;directory as the drawings to be changed.
;
;Because changing fonts can result in problems if the font sizes
;are different, keep your old drawings until you are sure that 
;all is well. This program will save the new drawings in a 
;subdirectory called FONTSUB off of the directory containing the 
;old drawings. YOU MUST CREATE THAT DIRECTORY prior to running 
;this program.
;
;See comments at the end of this code for some discussion on styles
;and text heights, if you're interested.
;
;*** sub to change table & entities ***

(defun fixfont()
   ;first fix the table - can't use entmod on table
   (command "style" stylename newfont (* ht factor) "" "" "" "" "" )
   ;if factor is not 1 then individual text entities height must be changed
   (if (/= factor 1.0)
      (progn
         (if (not ss);get all text entities - if not done previously
            (setq ss(ssget "X" '((0 . "TEXT"))))
         );end if
         (setq count 0)
			;check all existing text entities
         (repeat (sslength ss)
            (setq entlist(entget(ssname ss count)))
            (if (= (cdr(assoc 7 entlist)) stylename);if style is to be substituted
					;change it
               (progn
                  (setq oldht(cdr(assoc 40 entlist)))
                  (setq newht(* oldht factor))
                  (setq entlist
                     (subst (cons 40 newht)
                        (assoc 40 entlist)
                     entlist)
                  );end setq
                  (entmod entlist)
               );end progn
            );end if the right one
            (setq count (1+ count))
         );end repeat
      );end progn for 0 height
   );end if 0 height
);end fixfont sub defun

;*** main program ***
(defun fontsub()
   (if (setq ifile(open "FONTSUB.TXT" "r"));if user created the file
      (progn
         (setq ss nil)
         (while
            (setq inline(read-line ifile))
            (setq count 1)
            (while (/= (substr inline count 1) " ")
               (setq oldfont(strcase(substr inline 1 count)T))
               (setq count(1+ count))
            );end while
            (setq count (+ 1 count)
            mark count)
            (while (and (<= count (strlen inline))(/= (substr inline count 1) " "))
               (setq newfont(strcase(substr inline mark (1+(- count mark)))T))
               (setq count(1+ count))
            );end while
            (if (> (strlen inline) count)
               (setq factor(atof(substr inline count)))
               (setq factor 1)
            );end if
            (setq stylist(tblnext "STYLE" T))              ;rewind table and get first style
            (setq font(cdr(assoc 3 stylist)))             ;what style is it
            (if (= font oldfont)                         ;if it is the right one
               (progn
                  (setq ht(cdr(assoc 40 stylist)))             ;get height info
                  (setq stylename(cdr(assoc 2 stylist)))
                  (fixfont);call sub to fix it
               );end progn
            );if
            (while (setq stylist(tblnext "STYLE"))         ;get the rest of them
               (setq font(cdr(assoc 3 stylist)))        ;and their style
               (if (= font oldfont)                      ;if the right one
                  (progn
                     (setq ht(cdr(assoc 40 stylist))) ;get its height
                     (setq stylename(cdr(assoc 2 stylist)))
                     (fixfont)
                  );end progn
               );if   	
            );end while
         );end while reading file
      );end progn for file found
   );end if file existed
   (close ifile)
	;build save drawing path
	(setq cname(getvar "dwgname"))
	(setq count 1)
	(repeat (strlen cname)
		(if (= (substr cname count 1) (chr 92))
			(setq mark (1- count))
		);end if
		(setq count (1+ count))
	);end repeat
	;add FONTSUB subdirectory to build save drawing path
	(setq nname(strcat (substr cname 1 mark) (chr 92) "FONTSUB" (chr 92) (substr cname (+ 2 mark))))	
	(command "saveas" nname)	;save it in the subdirectory
	(setq ss nil) ;free the selection set
);end defun
;make this program 'load & go' - do this for all RUN LISP compatible programs.
(fontsub)

;ABOUT TEXT AND STYLES:
;
;If a style is defined with 0 height, the user enters the height each time text
;is entered.  This height is saved with the entity.  If the style is defined
;with a fixed height, the user is not prompted for height when text is entered.
;HOWEVER, the height is still saved with the entity and should the style be
;re-defined to have another height - it has no effect on previously entered
;text.  In addition to changing the defined height of each style whose font is
;being substituted, this program  also scales each text entity having that style
;by the factor given in the FONTSUB.TXT file.
;
;Not all fonts are the same size for the same defined height.

;end of file  



