# buildsfs.sh	build script for Space Flight Simulator, ver. 1.00
#
# set the following to your base directory for SFS sources,
# i.e., the directory from which sfs and io are both subdirectories
#
clear
echo Build Space Flight Simulator ver. 1.00
echo --------------------------------------
echo
echo This script should be placed in the top directory for SFS
echo sources, i.e., in the directory from which both io and 
echo sfs are subdirectories. It allows SFS to be built on the 
echo AT\&T Unix PC utilizing either TAM or MGR, or on a 
echo computer using the X Windows system. 
echo
echo Select system to build: 
echo
echo "    1  AT&T Unix PC using TAM"
echo "    2  AT&T Unix PC using MGR"
echo "    3  X Windows"
echo
echo "Press a key and RETURN: "
echo
read NUMBER
echo

if [ "$NUMBER" -eq 1 ]
	then
           echo "Building for AT&T Unix PC using TAM"
           cp makefile.tam makefile

else if [ "$NUMBER" -eq 2 ]
	then
           echo "Building for AT&T Unix PC using MGR"
           cp makefile.mgr makefile

else if [ "$NUMBER" -eq 3 ]
	then
           echo "Building for X Windows"
           cp makefile.x makefile

        else
           echo Choice not supported.
           exit 1

     fi
     fi
fi

echo copying as header...
cp ../as/as.h ../../include
echo copying bitmaps for runtime modules
cp ../../io/ui/*.pbm ../bin

echo
echo
echo Building SFS programs...
make all

echo
echo Program is complete.

#
#	end of buildsfs.sh
