/****************************************************************

	ui_text.c       Text handling routines for
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023
			Duke Station
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not
	be used for illegal activities.

****************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "string.h"
#include "gr.h"
#include "bw.h"
#include "ui.h"

#define MAXBUF  128
#define PIXEL_SPACES    3
#define SAFETY_MARGIN   1

/* #define GRDIRECT */               /* use gr_text function from ui_text */
				/* else use ui_str from ui_text */

ui_str( x1, y1, x2, background, foreground, buffer )
   int x1, y1, x2, background, foreground;
   char *buffer;
   {
   char buf[ MAXBUF ];
   int y, c;

   /* Write to buffer until overflow occurs */

   c = 0;
   y = FALSE;
   buf[ 0 ] = 0;
   while( y == FALSE )
      {
      buf[ c ] = buffer[ c ];
      ++c;
      buf[ c ] = 0;

      if ( c >= MAXBUF )
	 {
	 y = TRUE;
	 }
      else if ( gr_strlen( buf ) > ( x2 - x1 ) )
	 {
	 y = TRUE;
	 }
      else if ( buffer[ c ] == 0 )
	 {
	 y = TRUE;
	 }
      }

   /* Now reverse until last whitespace */

   --c;
   if ( gr_strlen( buf ) > ( x2 - x1 ))
      {
      while( isspace( buf[ c ] ) == FALSE )
	 {
	 buf[ c ] = 0;
	 --c;
	 }
      }

   if ( isspace( buf[ c ] ) != FALSE )
      {
      buf[ c ] = 0;
      }

   /* Display the string in the appropriate colors */

   gr_text( ui_screen, x1, y1, buf, foreground, background );
 
   }

ui_text( x1, y1, x2, y2, maxlines, background, foreground, main_buffer )
   int x1, y1, x2, y2;          /* Coordinates of box */
   int maxlines;                /* Maximum lines to be used */
   int background;              /* Background color */
   int foreground;              /* Foreground color */
   char *main_buffer;           /* Text buffer */
   {
   int l, c, y, main_pos, word_pos, lcount, line_pos, newline;
   int line_start, line_end, word_start, word_end;
   static char line_buffer[ 128 ];
   static char word_buffer[ 64 ];
#ifdef  OLD_DEBUG
   int X;
   static char Dbuffer[ BW_EBUFSIZE ];
#endif

   if ( ui_ready == FALSE )
      {
      bw_error( "The user interface is not initialized." );
      return;
      }

   /* set initial values */

   l = y2 - ( ui_grwind->fysize + PIXEL_SPACES );       /* l = location on y axis */
   y = TRUE;                                    /* continue loop */
   main_pos = 0;                                /* position in main buffer */
   lcount = 0;                                  /* count of lines */
   line_start = line_end = 0;

   /* loop for each word detected */

   while( y == TRUE )
      {
      newline = FALSE;

      /* if l extends below the box, abort */

      if ( l < y1 )
	 {
	 return;
	 }

      /* if line count exceeds max allowed, abort */

      if ( lcount >= maxlines )
	 {
	 return;
	 }

      /* Get one word (up to white space or end) in buffer */

      word_start = word_end = main_pos;
      word_pos = 0;
      word_buffer[ 0 ] = 0;
      while( ( isspace( main_buffer[ main_pos ] ) == FALSE )
	 && ( main_buffer[ main_pos ] != 0 ))
	 {
	 word_buffer[ word_pos ] = main_buffer[ main_pos ];
	 ++word_end;
	 ++main_pos;
	 ++word_pos;
	 word_buffer[ word_pos ] = 0;                 /* terminate word with 0 */
	 }

      /* Advance past any whitespace */

      while ( ( isspace( main_buffer[ main_pos ] ) != FALSE )
	 && ( main_buffer[ main_pos ] != 0 ))
	 {
	 if ( main_buffer[ main_pos ] == '\n' )
	    {
	    newline = TRUE;
	    word_buffer[ word_pos ] = 0;
	    }
	 else
	    {
	    word_buffer[ word_pos ] = main_buffer[ main_pos ];
	    }
	 ++main_pos;
	 ++word_pos;
	 ++word_end;
	 word_buffer[ word_pos ] = 0;                 /* set end of buffer to 0 */
	 }

#ifdef  OLD_DEBUG
      if ( gr_strlen( word_buffer ) > 100 )
	 {
	 sprintf( Dbuffer, "String element [%s]: may contain CR/LF",
	     word_buffer );
	 bw_debug( Dbuffer );
	 }
#endif

      /* Get the current line into the buffer */

      line_pos = 0;
      line_buffer[ 0 ] = 0;
      for ( c = line_start; c < line_end; ++c )
	 {
	 line_buffer[ line_pos ] = main_buffer[ c ];
	 ++line_pos;
	 line_buffer[ line_pos ] = 0;                   /* terminate with 0 */
	 }

#ifdef  OLD_DEBUG
      sprintf( Dbuffer, "line_buffer [%s], word_buffer [%s]", line_buffer, word_buffer );
      bw_debug( Dbuffer );
#endif

      /* Now, what do we do with the word we have detected? */
      /* 1. Check to see if new word will extend past limits */
      /*    if so, output 'line_buffer' only, and make word the */
      /*    new line_buffer */

      if ( ( x1 + gr_strlen( line_buffer ) + gr_strlen( word_buffer ) ) >= ( x2 - SAFETY_MARGIN ))
	 {
#ifdef  OLD_DEBUG
	 sprintf( Dbuffer, "Flush line: x1 = %d, line = %d, word = %d",
	    x1, gr_strlen( line_buffer ), gr_strlen( word_buffer ) );
	 bw_debug( Dbuffer );
	 sprintf( Dbuffer, "Flush line: x1 + word + line = %d, x2 = %d",
	    x1 + gr_strlen( line_buffer ) + gr_strlen( word_buffer ), x2 );
	 bw_debug( Dbuffer );
	 sprintf( Dbuffer, "Flush line: strlen( line ) = %d",
	    strlen( line_buffer ) );
	 bw_debug( Dbuffer );
#endif
#ifdef  GRDIRECT
	 gr_text( ui_screen, x1, l, line_buffer, foreground,
	    background );
#else
	 ui_str( x1, l, x2, background, foreground, line_buffer );
#endif
	 ++lcount;
	 l -= ( ui_grwind->fysize + PIXEL_SPACES );

	 /* now make the current word the new line */

	 line_start = word_start;
	 line_end   = word_end;

	 }

      /* 2. check to see if this is the end of the main buffer */
      /*    if so, flush and return */

      else if ( main_buffer[ main_pos ] == 0 )
	 {
	 strcat( line_buffer, word_buffer );
#ifdef  GRDIRECT
	 gr_text( ui_screen, x1, l, line_buffer,
	    foreground, background );
#else
	 ui_str( x1, l, x2, background, foreground, line_buffer );
#endif
	 return;
	 }

      /* 3. check to see if a newline has been encountered; if so */
      /*    output the current line */

      else if ( newline == TRUE )
	 {

#ifdef  OLD_DEBUG
	 sprintf( bw_ebuf, "Got a newline after %s|%s",
	    line_buffer, word_buffer );
	 bw_debug( bw_ebuf );
#endif

	 strcat( line_buffer, word_buffer );
#ifdef  GRDIRECT
	 gr_text( ui_screen, x1, l, line_buffer,
	    foreground, background );
#else
	 ui_str( x1, l, x2, background, foreground, line_buffer );
#endif
	 ++lcount;
	 l -= ( ui_grwind->fysize + PIXEL_SPACES );
	 line_start = line_end = main_pos;
	 }

      /* 4. else set end of current line to word_end and loop through */
      /*    again to get another word */

      else
	 {
	 line_end = word_end;
	 }
      }
   }


