; This program is made by Daniel Horchner.
; email: dbjh@gmx.net
;
; This is an example that shows that an INT instruction in V86 mode doesn't
; generate exception 13 if the DPL of that int is 3. Note that the ISR
; executes in protected mode.

        .386p
        locals

code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include raw32.inc

;32-bit data
SWAT            =       0

TSS1dsc         seg_descriptor  <2067h,,, 89h, 0,>
TSS1            TSS     <>
                db      2000h dup(0)    ; 1 bit for each port; 64K / 8 = 8K
TSS1sel         dw      0

org_exc13       dd      0               ; offset and selector of original
                dw      0               ;  exception 13 handler
org_tr          dw      0               ; original Task Register contents

msg0            db      'Not running at Privilege Level 0.','$'
msg1            db      'Message from ISR at Privilege Level 0.',0
msg2            db      'Message from exception 13 handler.',0
msg3            db      'Press a key to continue.',0

ifdef   SWAT
org_arbyte      db      0               ; original access rights byte exc 13
endif

;32-bit code
main:
                                        ; First, check if running at PL 0
        mov ebx,cs
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        jz short @@PL0
        mov edx,offset msg0
        call dosprint
        jmp exit
@@PL0:
;
        str org_tr                      ; Save original Task Register

        mov cx,1                        ; Allocate 1 descriptor for TSS
        call getdsc
        jc @exit
        mov TSS1sel,ax

        mov eax,code32a
        add eax,offset TSS1
        mov TSS1dsc.base0_15,ax
        shr eax,16
        mov TSS1dsc.base16_23,al
        mov TSS1dsc.base24_31,ah

        mov es,data32sel
        mov edi,offset TSS1dsc
        mov bx,TSS1sel                  ; bx=selector
        call setdsc
        jc @exit

        cli
        ltr TSS1sel
;
        mov bl,RMCALL_VECT+1
        mov cx,code32sel
        mov edx,offset PL0isr
        call setvect
        jc @exit
        sub esp,6                       ; Set int gate's DPL to 3 -> possible
        sidt [esp]                      ;  to call int from PL 3
        mov edi,[esp+2]
        add esp,6
        or byte ptr gs:[edi+(RMCALL_VECT+1)*8+5],3 shl 5

        mov bl,13
        call getvect
        mov word ptr org_exc13[4],cx    ; cx:edx=addr of exception handler
        mov org_exc13[0],edx

        mov cx,cs                       ; Install V86 monitor
        mov edx,offset V86monitor
        call setvect
        jc @exit
ifdef   SWAT
        mov al,gs:[edi+13*8+5]          ; Get access rights byte...
        mov org_arbyte,al               ; ...and save it
        mov al,8eh                      ; int gate, DPL 0, present
        mov gs:[edi+13*8+5],al          ; Set access rights byte
endif

        push ds es fs gs
        mov TSS1.ss0,ss                 ; Save protected mode ss:esp in Task
        mov TSS1.esp0,esp               ;  State Segment -> V86 monitor uses 
                                        ;  current stack
                                        ; Build stack frame for entering V86 
        push dword ptr v86r_gs          ;  mode: gs,
        push dword ptr v86r_fs          ;  fs,
        push dword ptr v86r_ds          ;  ds,
        push dword ptr v86r_es          ;  es,
        push large v86code              ;  ss,
        push large offset v86stackbase  ;  esp,
        pushfd                          ;  eflags,
        or [esp],20000h                 ; Set virtual 8086 mode flag
        push large v86code              ;  cs,
        push large offset v86start      ;  eip
        iretd                           ; VM bit in eflags on stack is set ->
retfromV86:                             ;  get eip, cs, eflags, esp, ss, es,
        pop gs fs es ds                 ;  ds, fs, gs from stack -> V86 mode

        mov bl,13
        mov cx,word ptr org_exc13[4]    ; cx:edx=addr of exception handler
        mov edx,org_exc13[0]
        call setvect
ifdef   SWAT
        sub esp,6
        sidt [esp]
        mov ebx,[esp+2]
        add esp,6
        mov al,org_arbyte               ; Get original access rights byte...
        mov gs:[ebx+13*8+5],al          ; ...and restore it
endif

@exit:
        sub esp,6
        sgdt [esp]
        mov eax,[esp+2]
        add esp,6
        movzx ebx,org_tr
        and ebx,not 3                   ; ebx=offset of TSS dsc in GDT
        and byte ptr gs:[eax+ebx+5],not 2 ; Clear Busy bit
        ltr org_tr                      ; Restore original Task Register
        sti

        mov esi,offset msg3
        @rlp edi,0b8000h+3*160
        mov bl,1fh
        call putstr
        mov v86r_ah,0                   ; ah=0 -> Wait for key and read char
        mov al,16h
        int RMCALL_VECT
        jmp exit                        ; Return to real/V86 mode

;
V86monitor:                             ; General protection
        add esp,10*4                    ; exc in V86 -> gs,fs,ds,es,ss,esp,
        mov ds,cs:data32sel             ;  eflags,cs,eip,error code on stack
        mov es,cs:data32sel
        mov esi,offset msg2
        @rlp edi,0b8000h+2*160
        mov bl,1fh
        call putstr
        jmp retfromV86

;
PL0isr:
        mov eax,cr0                     ; Exception 13 if this is PL > 0 code
        mov ds,cs:data32sel
        mov es,cs:data32sel
        mov esi,offset msg1
        @rlp edi,0b8000h+1*160
        mov bl,1fh
        call putstr
        iretd

code32  ends

v86code segment para public use16
        assume cs:v86code, ds:v86code, ss:v86code

;16-bit data
v86stack        db      100 dup(0)      ; V86 mode stack
v86stackbase    label

v86msg          db      'Message from Virtual 8086 mode.'
v86msglen       =       $-v86msg

;16-bit code
v86start:
        mov ax,cs
        mov ds,ax
        mov si,offset v86msg
        mov ax,0b800h
        mov es,ax
        mov di,0
        mov cx,v86msglen
        mov ah,1fh
@@putchar:
        lodsb
        stosw
        loop @@putchar

        int RMCALL_VECT+1               ; Call protected mode int

        int RMCALL_VECT                 ; int in V86 with DPL < 3 -> exc 13

v86code ends

        end
