;    GRDB - debugger for dos with 32-bit extensions
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
;
; prints.asm
;
;  Function: Print utilities.  All I/O with monitor is logged
;
;
	;MASM MODE
	.model small
	.386

include elogging.inc
include eoptions.inc

	PUBLIC	printspace,printdword,printword,printbyte
	PUBLIC	PureChar, PutChar, GetKey, PrintFollowingMessage, scankey
	PUBLIC  crlf, olMessage, dgroupMessage
        public  getcurpos, setcurpos, blockcurs, underlinecurs, getcurshape

        .data
curshape        dw      0
	.code

;
; dump a message
; INPUT: BX points at message
;	NOTE: This proc is identical to olmessage below. Maybe this one
;	exists only for exercise in dreaming up labels.
;
dgroupMessage	PROC
	push	dx		;preserve DX
dil:
	mov	dl,[bx]
	inc	bx
	or	dl,dl
	jz	dix
	call	PutChar
	jmp	dil
dix:
	pop	dx
	ret
dgroupMessage	ENDP

PrintFollowingMessage	Proc
	xchg	bx,[esp]
	call	olmessage
	xchg	bx,[esp]
	ret
PrintFollowingMessage	Endp

olMessage Proc
	push	dx
mlp:
	mov	dl,cs:[bx]
	inc	bx
	or	dl,dl
	jz	nomore
	call	putchar
	jmp	mlp
nomore:
	pop	dx
	ret
olMessage ENDP

;
; print a (pure) char
;
; chars are limited to ASCII unless the pure video option is set,
; in chich case we display everything but a few control chars the
; BIOS will try to interpret and wreck our display
;
purechar	PROC
	test	[optdosio],0ffh
        jnz     unpure
	test	[optpure],0ffh
        jnz     purefix
unpure:
	cmp	dl,20h
	jc	npure1
	cmp	dl,80h
	jc	PutChar
npure1:
	mov	dl,'.'
	jmp	PutChar

purefix:
	cmp	dl,20h
	jnc	putchar
	cmp	dl,13
	jz	ccr
	cmp	dl,10
	jz	ccr
	cmp	dl,7
	jz	ccr
	cmp	dl,8
	jz	ccr
	cmp	dl,9
	jz	ccr
	jmp	putchar
ccr:
	mov	dl,'.'
purechar	ENDP
;
; normal put char via bios or dos.  Also logs to disk
;
putchar	PROC
	push	bx
	mov	ah,0fh
	int	10h
	mov	bl,15
	mov	al,dl
	cmp	al,9
	jz	dotab
	jmp	occon
ocx:
	push	bx
occon:
	call	logtofile
	test	[optdosio],0ffh
	jnz	pcdos
	mov	ah,0eh
	int	10h
	pop	bx
	ret
pcdos:
	push	dx
	mov	dl,al
	mov	ah,2
	int	21h
	pop	dx
	pop	bx
	ret
dotab:
	push	cx
	mov	ah,3
	int	10h
	movzx	cx,dl
	inc	cl
	and	cl,7
	neg	cl
	add	cl,8
dtl:
	mov	al,20h
	call	ocx
	loop	dtl
	pop	cx
	pop	bx
	ret
putchar	ENDP
;
; keyboard input via bios
;
getkey 	PROC
	test	[optdosio],0ffh
	jnz	dosgetkey
	sub	ax,ax
	int	16h
	ret
getkey ENDP
dosgetkey PROC
	push	dx
dgkl:
	mov	ah,6
	mov	dl,0ffh
	int	21h
	jz	dgkl
	or	al,al
	pop	dx
        jnz     dgkr
dgkl2:
        mov     ah,6
        mov     dl,0ffh
        int     21h
        jz      dgkl2
        mov     ah,al
        sub     al,al
        ret
dgkr:
        sub     ah,ah
        ret
dosgetkey	ENDP

dosgetkey2	PROC
	push	dx
	jnz	dgknv
	mov	ah,6
	mov	dl,0ffh
	int	21h
dgknv:
	pop	dx
	cmp	al,10
	jz	dosgetkey
	ret
	
dosgetkey2	ENDP
;
; keyboard scan, used to halt long D and U commands
;
scankey	PROC
	test	[optdosio],0ffh
	jnz	dosscankey
	mov	ah,1
	int	16h
	jz	scandone
	pushf
	call	getkey
	popf
scandone:
	ret
dosscankey:
        push    dx
        mov     ah,6
        mov     dl,0ffh
        int     21h
        pop     dx
	ret

scankey	ENDP
;
; put out a space
;
printspace:
	push	dx
	mov	dl,20h		; Get a space
	call	PutChar
	pop	dx
	ret
;
; put out a CR/LF sequence
;
crlf:
	push	dx
	mov	dl,13		; Get a CR
	call	PutChar
	mov	dl,10		; Get a LF
	call	PutChar
	pop	dx
	ret
;
; print various hex numbers
;
printdword:
	push	eax		; To print a dword
	shr	eax,16		; Print the high 16 bits
	call	printword
	pop	eax		; And the low 16 bits
printword:
	push	ax		; To print a word
	mov	al,ah		; Print the high byte
	call	printbyte
	pop	ax		; And the low byte
printbyte:
	push	ax		; To print a byte
	shr	al,4		; Print the high nibble
	call	printnibble
	pop	ax		; And the low nibble
printnibble:
	and	al,0fh		; Get a nibble
	add	al,'0'		; Make it numeric
	cmp	al,'9'		; If supposed to be alphabetic
	jle	onib
	add	al,7		; Add 7
onib:
	push	dx		; Save DX through the call
	mov	dl,al
	call	PutChar
	pop	dx		;
	ret
getcurpos PROC
        push    si
        push    di
        mov     ah,3
        mov     bh,0
        int     10h
        pop     di
        pop     si
        ret
getcurpos ENDP
setcurpos PROC
        push    si
        push    di
        mov     ah,2
        mov     bh,0
        int     10h
        pop     di
        pop     si
        ret
setcurpos ENDP
getcurshape PROC
        call    getcurpos
        mov     [curshape],cx
        ret
getcurshape ENDP
blockcurs PROC
        mov     cx,[curshape]
        mov     ch,0
        mov     ah,1
        int     10h
        ret        
blockcurs ENDP
underlinecurs PROC
        mov     cx,[curshape]
        mov     ah,1
        int     10h
        ret        
underlinecurs ENDP
END