;
; GRDP
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; INOUT.ASM
;
; Function: Handle I,O commands
;
	;MASM MODE
	.MODEL SMALL
	.386


include  eprints.inc 
include  einput.inc 
include  emtrap.inc 
include  ebreaks.inc 

	PUBLIC doin,doout

	.CODE
;
; get the size
;
iosize	proc
	sub	cx,cx
	lodsb
	cmp	al,13
	jz	szerr
	cmp	al,'b'
	jz	gotsize
	inc	cx
	cmp	al,'w'
	jz	gotsize
	inc	cx
	cmp	al,'d'
	jz	gotsize
	dec	si
	sub	cx,cx
gotsize:
	shl	cx,1
	clc
	ret
szerr:
	dec	si
	stc
	ret
iosize endp
;
; Read from a port
;
doin	PROC	
	call	iosize
	jc	inerr
	Call	WadeSpace	; Wade till address
	jz	inerr
	call	ReadNumber
	jc	inerr
	mov	edx,eax
	call	WadeSpace
	jnz	inerr
	mov	bx,cx
	jmp	word ptr [bx+intab]
intab	dw	offset inbyte, offset inword, offset indword
inbyte:
	call	crlf
	in	al,dx
      	call	printbyte	; Print data
	clc
	ret
inword:
	call	crlf
	in	ax,dx
      	call	printword	; Print data
	clc
	ret
indword:
	call	crlf
	in	eax,dx
      	call	printdword	; Print data
	clc
	ret
inerr:
	stc
	ret
doin	ENDP
;
; Write to a port
;
doout	PROC
	call	iosize
	jc	outerr
	Call	WadeSpace	; Wade till address
	jz	outerr
	call	ReadNumber
	jc	outerr
	mov	dx,ax
	call	WadeSpace
	jz	outerr
	call	ReadNumber
	jc	outerr
	mov	ebx,eax
	call	WadeSpace
	jnz	outerr
	mov	eax,ebx
	mov	bx,cx
	jmp	[bx + outtab]
outtab	dw	offset outbyte,offset outword, offset outdword
outbyte:
	out	dx,al
	clc
	ret
outword:
	out	dx,ax
	clc
	ret
outdword:
	out	dx,eax
	clc
	ret
outerr:
	ret
doout	ENDP
end