
From Herman Dullink:

For most systems, I can create a device driver within the hour with
only debug :-) I first 'C:\> debug > rom' and then 'u F000:0,FFFE'   or
something. And then search for 'C000', 'C400', 'C800' etc.. in   the
'rom' file. The 'shadow' code is nearby.

All the UMB driver does is:
- search for an XMS driver, if none present, installs a 144 byte
  XMS   driver which only can return the version number...
- copies the UMB functions (144 bytes) to the UMA, and 'chains' it
  to the XMS driver.
- the UMB functions implemented are 'allocate' and 'free' UMB.


From  Adam Fitzpatrick:

I saw HD's original message and thought it was a good idea to write a device
driver to do this; I noticed that I was always 384k short of the 4Mb I should
have, regardless of whether shadowing was in use. So I looked at BIOS and found
the shadowing code as HD advised and wrote the device driver. Strangely however,
I found that I could get it to work without any memory-resident code at all.

The way EMM386 implements UMBs is apparently different to the XMS-style UMB. I
initially tried to write the XMS UMB functions and noticed that MSD recognised
them as "XMS UMB" rather than simply UMB as it does with EMM386's UMBs, so I
looked through Ralf Brown's interrupt list and found that there's a place in
memory where DOS 5+ stores the segment address of the first UMB MCB, which is at
9FFF for EMM386.

I then wrote code that followed the MCB chain until it found the one that starts
with "Z" (the last one) and reduced its size by one (I'm not sure whether it's
possible for a device driver to have used the last block in memory; AFAIK
they're all loaded as low in conventional memory as possible; even if not it
doesn't require HIMEM.SYS to be loaded so I could put it first anyway). I then
created an MCB at the last paragraph in memory (the one I just took out of the
last MCB) which is the "excluded UMB area", which is the number of paragraphs
between 9FFF and the MCB for the first UMB.

Anyway, here's most of the code (except for the shadowing bit, which was
probably of no use to you anyway):

=== Cut ===
ideal
p386
jumps
model tiny
codeseg
assume cs:_text,ds:_text,es:_text

 org 0
; Device header
 dd -1   ;next
 dw 8000h   ;attr
 dw strat   ;strategy
 dw intrpt   ;interrupt
 db 'DROWGORF'  ;name - doesn't matter because it doesn't stay in memory

; driver call data
rqblk dw ?,?   ;request header ptr

proc strat far ;"strategy" routine
 mov [cs:rqblk],bx
 mov [cs:rqblk+2],es
 ret
endp strat

proc intrpt far
 push ax bx cx dx si di bp ds es
 lds di,[dword ptr cs:rqblk]
 mov [word ptr di+3],8103h    ;"invalid function"
 cmp [byte ptr di+2],0  ;is this the initialisation call?
 jne leave_   ;no, it's stuffed (invalid function)
 call init    ;initialisation routine
leave_: pop es ds bp di si dx cx bx ax
 ret
endp intrpt

;initialisation
proc init
 mov [byte ptr di+0Dh],0 ;number of units
 mov [word ptr di+0Eh],0
     ;end of code offset - 0 means device driver "couldn't load" ie it's
     ;not retained in memory
 mov [word ptr di+10h],cs ;segment address
 mov [word ptr di+03h],0100h ;"function worked OK"
;--SNIP-- [Shadow RAM code]
 mov ah,52h
 int 21h   ;get heaps of DOS information...
 mov ax,[es:bx-2] ;this is the first MCB in memory
 mov fs,ax ;I don't know why I used FS :)
zlp: cmp [byte ptr fs:0],'Z' ;the last MCB?
 je got_z ;yep!
 mov bx,fs
 add bx,[fs:3] ;nope - calculate next MCB
 inc bx
 mov fs,bx
 jmp short zlp
got_z: mov [byte ptr fs:0],'M' ;I'm not sure whether this is necessary
 mov bx,fs
 add bx,[fs:3]
 dec [word ptr fs:3]
 mov fs,bx
 mov [byte ptr fs:0],'M'
 mov [word ptr fs:1],8 ;this means "reserved for DOS" or something
;note: the next few lines assume that the UMB goes from D000:0-F000:7FFF
;because mine does :)
 mov ax,0CFFFh
 sub ax,bx
 mov [fs:3],ax ;calculate size of excluded UMB area
 mov [word ptr fs:8],'CS' ;DOS System Code - not sure if needed
 mov [dword ptr fs:10],0
 mov [word ptr fs:14],0
 mov ax,0D000h
 mov fs,ax
 mov [byte ptr fs:0],'M'
 mov [word ptr fs:1],0
 mov [word ptr fs:3],8191 ;8191*16=131056: size of MCB
 mov ax,0F000h
 mov fs,ax
 mov [byte ptr fs:0],'Z' ;last MCB in chain
 mov [word ptr fs:1],0
 mov [word ptr fs:3],2047 ;2047*16=32752: size of MCB
 mov ah,52h
 int 21h ;get DOS info again [I know this ain't efficient!]
 les bx,[es:bx+12h] ;get another list of info
 or [byte ptr es:bx+1Ch],1 ;this means "UMBs present"
 mov [word ptr es:bx+1Fh],9FFFh ;this is start of UMB MCB chain
 ret
endp init

end
