; TENIE REMMEL

;Scroll UP ------------------------------------------------- 
 
Ideal 
Model Tiny 
CodeSeg 
Org 100h 
 
Proc        Program 
 
            mov ax,0B800h       ;Load segment registers 
            mov es,ax 
            xor si,si           ;Copy video memory 
            mov di,4000

            mov cx,di 
            seges rep movsb 
             
            mov dx,03D4h 
 
ScrnLoop:   xor cx,cx           ;Start Address 0 
 
ChLoop:     mov al,0Ch          ;Set Start Address 
            mov ah,ch 
            out dx,ax           ;high... 
            inc ax 
            mov ah,cl 
            out dx,ax           ;and low. 
             
            xor bx,bx           ;Row Scan = 0 
            add cx,80           ;advance text line 
 
PixLoop:    add dx,6 
 
VRTLoop1:   in al,dx            ;Wait for next VRT 
            test al,8 
            jnz VRTLoop1 
VRTLoop2:   in al,dx 
            test al,8 
            jz VRTLoop2 
             
            sub dx,6 
            mov al,8            ;Set Row Scan 
            mov ah,bl 
            out dx,ax 
 
            inc bx              ;Text line done? 
            test bx,16 
            jz PixLoop 
 
            in al,60h           ;Escape pressed? 
            cmp al,81h 
            jz Done 
 
            cmp cx,2000         ;Screen done? 
            jl ChLoop 
 
            jmp ScrnLoop 
 
Done:       mov ax,8 
            out dx,ax 
            add ax,4 
            out dx,ax 
            inc ax 
            out dx,ax 
            ret 
 
EndP        Program 
 
End Program 
 
 
;Scroll DOWN ----------------------------------------------- 
 
Ideal 
Model Tiny 
CodeSeg 
Org 100h 
 
Proc        Program 
 
            mov ax,0B800h       ;Load segment registers 
            mov es,ax 
            xor si,si           ;Copy video memory 
            mov di,4000 
            mov cx,di 
            seges rep movsb 
             
            mov dx,03D4h 
 
ScrnLoop:   mov cx,1920         ;Start Address 1920 
 
ChLoop:     mov al,0Ch          ;Set Start Address 
            mov ah,ch 
            out dx,ax           ;high... 
            inc ax 
            mov ah,cl 
            out dx,ax           ;and low. 
             
            mov bx,15           ;Row Scan = 15 
            sub cx,80           ;advance text line 
 
PixLoop:    add dx,6 
 
VRTLoop1:   in al,dx            ;Wait for next VRT 
            test al,8 
            jnz VRTLoop1 
VRTLoop2:   in al,dx 
            test al,8 
            jz VRTLoop2 
             
            sub dx,6 
            mov al,8            ;Set Row Scan 
            mov ah,bl 
            out dx,ax 
 
            dec bx              ;Text line done? 
            test bx,bx 
            jge PixLoop 
 
            in al,60h           ;Escape pressed? 
            cmp al,81h 
            jz Done 
 
            cmp cx,0            ;Screen done? 
            jge ChLoop 
 
            jmp ScrnLoop 
 
Done:       mov ax,8 
            out dx,ax 
            add ax,4 
            out dx,ax 
            inc ax 
            out dx,ax 
            ret 
 
EndP        Program 
 
End Program 
 
 
;Scroll DIAGONALLY (up/left) ------------------------------- 
 
Ideal 
Model Tiny 
CodeSeg 
Org 100h 
 
Proc        Program 
 
            mov ax,0B800h       ;Load segment registers 
            mov es,ax 
            xor si,si           ;Copy video memory 
            mov di,4000 
            mov cx,di 
            seges rep movsb 
 
            mov cx,2000 
 
ScrnLoop:   sub cx,2000         ;Start Address 0 
 
ChLoop:     mov dx,03D4h 
            mov al,0Ch          ;Set Start Address 
            mov ah,ch 
            out dx,ax           ;high... 
            inc ax 
            mov ah,cl 
            out dx,ax           ;and low. 
             
            xor bx,bx           ;Row Scan = 0 
            add cx,81           ;advance text line/col 
 
PixLoop:    mov dx,03DAh 
 
VRTLoop1:   in al,dx            ;Wait for next VRT 
            test al,8 
            jnz VRTLoop1 
VRTLoop2:   in al,dx 
            test al,8 
            jz VRTLoop2 
             
            test bl,1           ;Is it an even pixel? 
            jnz IsOdd 
             
            mov dx,03C0h        ;If so, set Pixel Pan 
            mov al,33h 
            out dx,al 
            mov al,bl 
            shr al,1 
            out dx,al 
 
IsOdd:      mov dx,03D4h 
            mov al,8            ;Set Row Scan 
            mov ah,bl 
            out dx,ax 
 
            inc bx              ;Text line done? 
            test bx,16 
            jz PixLoop 
 
            in al,60h           ;Escape pressed? 
            cmp al,81h 
            jz Done 
 
            cmp cx,2000         ;Screen done? 
            jl ChLoop 


            jmp ScrnLoop 
 
Done:       mov ax,8 
            out dx,ax 
            add ax,4 
            out dx,ax 
            inc ax 
            out dx,ax 
            mov dx,03C0h 
            mov al,33h 
            out dx,al 
            mov al,8

            out dx,al 
            ret 
 
EndP        Program 
 
End Program 
