# Turbo-Make / UNIX Makefile for Difference file creation by F van der Hulst

# Turbo C stuff

# CC     =c:\tc\tcc
# OBJ    =obj
# LINK   =c:\tc\tlink
# CFLAGS =-mc -1 -a -K -G -O -Z -d -c -k- -N- -v- -p -C -Ic:\tc\include -w
# LFLAGS =c:\tc\lib\c0c+diff, diff, nul, c:\tc\lib\emu+c:\tc\lib\mathc+c:\tc\lib\cc;

# Following are for SCO Unix:
CC     = cc
LINK   = cc
OBJ    = o
CFLAGS = -c -M3 -J -Ox
LFLAGS = -o animgif.exe -Ox -lm


# Implicit rules for making an object file from a .C file...
#
.c.$(OBJ) :
        $(CC) $(CFLAGS) $*.c

OBJS = quant.$(OBJ) files.$(OBJ) egif_lib.$(OBJ) gif_hash.$(OBJ) octree.$(OBJ)

animgif.exe : $(OBJS)
	$(CC) $(CFLAGS) animdiff.c
        $(LINK) $(OBJS) $(LFLAGS)
        mv animgif.exe ../bin/animgif

animgif.$(OBJ)    : animgif.c gif_lib.h

egif_lib.$(OBJ) : egif_lib.c gif_lib.h gif_hash.h

gif_hash.$(OBJ) : gif_hash.c gif_hash.h
