PACKAGE BODY Stacks_Generic IS
------------------------------------------------------------------
--| Body of generic package for LIFO stacks
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  PROCEDURE MakeEmpty (S : IN OUT Stack) IS
  BEGIN
    Lists.MakeEmpty(S.Store);
  END MakeEmpty;

  PROCEDURE Push (S : IN OUT Stack; E : IN StackElement) IS
  BEGIN
    Lists.AddToFront (S.Store, E);
  END Push;

  PROCEDURE Pop (S : IN OUT Stack) IS
  BEGIN
    IF Lists.IsEmpty (S.Store) THEN
      RAISE StackEmpty;
    ELSE
      Lists.RemoveFront(S.Store);
    END IF;
  END Pop;  

  FUNCTION Top (S : IN Stack) RETURN StackElement IS
  BEGIN
    IF Lists.IsEmpty (S.Store) THEN
      RAISE StackEmpty;
    ELSE
      RETURN Lists.RetrieveFront (S.Store);
    END IF;
  END Top;  

  FUNCTION IsEmpty (S : IN Stack) RETURN Boolean IS
  BEGIN
    RETURN Lists.IsEmpty (S.Store);
  END IsEmpty;

  PROCEDURE Dummy (Item: StackElement) IS
  BEGIN
    NULL;
  END Dummy;

END Stacks_Generic;
