WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Sort_3_Numbers IS
------------------------------------------------------------------
--| Reads three numbers and sorts them
--| so that they are in increasing order.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  Num1 : Float;            -- a list of three cells   
  Num2 : Float;            
  Num3 : Float;            

  -- procedure specification
  PROCEDURE Order (X: IN OUT Float; Y: IN OUT Float);

  -- procedure body
  PROCEDURE Order (X: IN OUT Float; Y: IN OUT Float) IS
  -- Pre:  X and Y are assigned values.
  -- Post: X has the smaller value and Y has the larger value.

    Temp : Float;          -- copy of number originally in X   

  BEGIN  -- Order   

    IF X > Y THEN
      -- interchange the values of X and Y   
      Temp := X;            -- Store old X in Temp   
      X := Y;               -- Store old Y in X   
      Y := Temp;            -- Store old X in Y   
    END IF;

  END Order;


BEGIN  -- Sort_3_Numbers   

  Ada.Text_IO.Put(Item => "Enter 3 float numbers to be sorted, one per line.");
  Ada.Text_IO.New_Line;
  Ada.Float_Text_IO.Get(Item => Num1);  
  Ada.Float_Text_IO.Get(Item => Num2); 
  Ada.Float_Text_IO.Get(Item => Num3);  

  -- Sort the numbers   
  Order (X => Num1, Y => Num2);      -- Order the data in Num1 and Num2   
  Order (X => Num1, Y => Num3);      -- Order the data in Num1 and Num3
  Order (X => Num2, Y => Num3);      -- Order the data in Num2 and Num3   

  -- Display the results.   
  Ada.Text_IO.Put(Item => "The three numbers in order are: ");
  Ada.Float_Text_IO.Put(Item => Num1, Fore => 5, Aft => 2, Exp => 0);  
  Ada.Float_Text_IO.Put(Item => Num2, Fore => 5, Aft => 2, Exp => 0);  
  Ada.Float_Text_IO.Put(Item => Num3, Fore => 5, Aft => 2, Exp => 0);  
  Ada.Text_IO.New_Line;

END Sort_3_Numbers;
