GENERIC
  TYPE ElementType IS PRIVATE;
  WITH PROCEDURE DisplayElement (Item: IN ElementType);
PACKAGE Lists_Generic IS
------------------------------------------------------------------
--| Specification for generic singly-linked lists 
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  TYPE List IS LIMITED PRIVATE;

  ListEmpty: EXCEPTION;

  PROCEDURE MakeEmpty (L : IN OUT List);
  -- Pre:    L is defined
  -- Post:   L is empty

  FUNCTION IsEmpty (L : IN List) RETURN Boolean;
  -- Pre:    L is defined
  -- Post:   returns True if L is empty, False otherwise

  PROCEDURE AddToFront (L: IN OUT List; Element: IN ElementType);
  -- Pre:  Element is defined; L may be empty
  -- Post: Element is inserted at the beginning of L

  FUNCTION RetrieveFront (L: IN List) RETURN ElementType;
  -- Pre:    L is defined; L may be empty
  -- Post:   returns a complete copy of the list L
  -- Raises: ListEmpty if the list is empty before the retrieval
 
  PROCEDURE RemoveFront (L: IN OUT List);
  -- Pre:    L is defined; L may be empty
  -- Post:   The first node of L is removed
  -- Raises: ListEmpty if the list is empty before the removal
 
  PROCEDURE AddToEnd (L: IN OUT List; Element: IN ElementType);
  -- Pre:  Element is defined; L may be empty
  -- Post: Element is appended to the end of L
 
  PROCEDURE Copy (Target: OUT List; Source: IN List);
  -- Pre:  Source may be empty
  -- Post: Returns a complete copy of Source in Target

  PROCEDURE Display (L: IN List);
  -- Pre:  L may be empty
  -- Post: displays the contents of L's Element fields, in the 
  --   order in which they appear in L

PRIVATE

  TYPE ListNode;
  TYPE ListPtr IS ACCESS ListNode;
  TYPE ListNode IS RECORD
    Element: ElementType;
    Next: ListPtr;
  END RECORD;

  TYPE List IS RECORD
    Head: ListPtr;
    Tail: ListPtr;
  END RECORD;

END Lists_Generic;
