PACKAGE Matrices IS
------------------------------------------------------------------------
--| Specification for package Matrices
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------------
 
  TYPE Matrix IS ARRAY(Integer RANGE <>, Integer RANGE <>) OF Float;

  -- exported exception, raised if two matrices are not conformable
  Bounds_Error : EXCEPTION;

  FUNCTION "+" (K : IN Float; M : IN Matrix) RETURN Matrix;
  -- adds a scalar to a matrix
  -- Pre: K and M are defined
  -- Post: returns the sum of the scalar and the matrix
  --   Result(i,j) := K + M(i,j)

  FUNCTION "*" (K : IN Float; M : IN Matrix) RETURN Matrix;
  -- multiplies a matrix by a scalar
  -- Pre: K and M are defined
  -- Post: returns the product of the scalar and the matrix
  --   Result(i,j) := K * M(i,j)

  FUNCTION "+" (Left, Right : IN Matrix) RETURN Matrix;
  -- finds the sum of two matrices
  -- Pre: Left and Right are defined and have the same bounds
  -- Post: returns the sum of Left and Right
  --   Result(i,j) := Left(i,j) + Right(i,j)
  --   Raises Bounds_Error if the matrices are not conformable

  FUNCTION "*" (Left, Right : IN Matrix) RETURN Matrix;
  -- finds the product of two matrices
  -- Pre: Left and Right are defined
  --   and Left's column bounds agree with Right's row bounds
  -- Post: returns the product of Left and Right
  --   Raises Bounds_Error if the matrices are not conformable

  FUNCTION Transpose(M : IN Matrix) RETURN Matrix;
  -- finds the transpose of a matrix
  -- Pre: M is defined
  -- Post: returns a matrix such that Result(i,j) = M(j,i)
  --   Result has M's bounds, interchanged

END Matrices;
