


RCSFILE(5)                                             RCSFILE(5)


NAME
       rcsfile - format of RCS file

DESCRIPTION
       An RCS file's contents are described by the grammar below.

       The text is free format: space, backspace,  tab,  newline,
       vertical  tab,  form  feed,  and  carriage return (collec-
       tively,  white  space)  have  no  significance  except  in
       strings.  However, white space cannot appear within an id,
       num, or sym, and an RCS file must end with a newline.

       Strings are enclosed by @.  If a string contains a  @,  it
       must  be doubled; otherwise, strings can contain arbitrary
       binary data.

       The meta syntax uses the following conventions: `|'  (bar)
       separates  alternatives;  `{'  and  `}'  enclose  optional
       phrases; `{' and `}*' enclose phrases that can be repeated
       zero or more times; `{' and '}+' enclose phrases that must
       appear at least once and can be repeated; Terminal symbols
       are in boldface; nonterminal symbols are in italics.

       rcstext   ::=  admin {delta}* desc {deltatext}*

       admin     ::=  head       {num};
                      { branch   {num}; }
                      access     {id}*;
                      symbols    {sym : num}*;
                      locks      {id : num}*;  {strict  ;}
                      { comment  {string}; }
                      { expand   {string}; }
                      { newphrase }*

       delta     ::=  num
                      date       num;
                      author     id;
                      state      {id};
                      branches   {num}*;
                      next       {num};
                      { newphrase }*

       desc      ::=  desc       string

       deltatext ::=  num
                      log        string
                      { newphrase }*
                      text       string

       num       ::=  {digit | .}+

       digit     ::=  0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9

       id        ::=  {num} idchar {idchar | num}*



GNU                         1995/06/05                          1





RCSFILE(5)                                             RCSFILE(5)


       sym       ::=  {digit}* idchar {idchar | digit}*

       idchar    ::=  any visible graphic character except special

       special   ::=  $ | , | . | : | ; | @

       string    ::=  @{any character, with @ doubled}*@

       newphrase ::=  id word* ;

       word      ::=  id | num | string | :

       Identifiers  are  case  sensitive.   Keywords are in lower
       case only.  The sets of keywords and identifiers can over-
       lap.   In most environments RCS uses the ISO 8859/1 encod-
       ing: visible graphic  characters  are  codes  041-176  and
       240-377,  and white space characters are codes 010-015 and
       040.

       Dates, which appear after the date  keyword,  are  of  the
       form  Y.mm.dd.hh.mm.ss,  where Y is the year, mm the month
       (01-12), dd the day (01-31), hh the hour (00-23),  mm  the
       minute  (00-59),  and  ss  the second (00-60).  Y contains
       just the last two digits of the year for years  from  1900
       through  1999,  and  all  the  digits of years thereafter.
       Dates use the Gregorian calendar; times use UTC.

       The newphrase productions in the grammar are reserved  for
       future  extensions  to  the  format of RCS files.  No new-
       phrase will begin with any keyword already in use.

       The delta nodes form a tree.  All nodes whose numbers con-
       sist  of a single pair (e.g., 2.3, 2.1, 1.3, etc.)  are on
       the trunk, and are linked through the next field in  order
       of  decreasing  numbers.  The head field in the admin node
       points to the head of that sequence  (i.e.,  contains  the
       highest  pair).   The  branch node in the admin node indi-
       cates the default branch (or revision) for most RCS opera-
       tions.  If empty, the default branch is the highest branch
       on the trunk.

       All delta nodes whose numbers consist of 2n fields  (n>=2)
       (e.g.,  3.1.1.1,  2.1.2.2,  etc.)   are linked as follows.
       All nodes whose first 2n-1 number fields are identical are
       linked  through the next field in order of increasing num-
       bers.  For each such sequence, the delta node whose number
       is identical to the first 2n-2 number fields of the deltas
       on that sequence is called the branchpoint.  The  branches
       field  of  a  node  contains  a list of the numbers of the
       first nodes of all sequences for which  it  is  a  branch-
       point.  This list is ordered in increasing numbers.

       The  following  diagram  shows an example of an RCS file's
       organization.



GNU                         1995/06/05                          2





RCSFILE(5)                                             RCSFILE(5)


                                  Head
                                    |
                                    |
                                    v                        / \
                                ---------                   /   \
          / \          / \      |       |      / \         /     \
         /   \        /   \     |  2.1  |     /   \       /       \
        /     \      /     \    |       |    /     \     /         \
       /1.2.1.3\    /1.3.1.1\   |       |   /1.2.2.2\   /1.2.2.1.1.1\
       ---------    ---------   ---------   ---------   -------------
           ^            ^           |           ^             ^
           |            |           |           |             |
           |            |           v           |             |
          / \           |       ---------      / \            |
         /   \          |       \  1.3  /     /   \           |
        /     \         ---------\     /     /     \-----------
       /1.2.1.1\                  \   /     /1.2.2.1\
       ---------                   \ /      ---------
           ^                        |           ^
           |                        |           |
           |                        v           |
           |                    ---------       |
           |                    \  1.2  /       |
           ----------------------\     /---------
                                  \   /
                                   \ /
                                    |
                                    |
                                    v
                                ---------
                                \  1.1  /
                                 \     /
                                  \   /
                                   \ /



IDENTIFICATION
       Author:  Walter  F.   Tichy,   Purdue   University,   West
       Lafayette, IN, 47907.
       Manual Page Revision: 5.6; Release Date: 1995/06/05.
       Copyright (C) 1982, 1988, 1989 Walter F. Tichy.
       Copyright  (C)  1990,  1991,  1992,  1993, 1994, 1995 Paul
       Eggert.

SEE ALSO
       rcsintro(1), ci(1), co(1), ident(1), rcs(1),  rcsclean(1),
       rcsdiff(1), rcsmerge(1), rlog(1)
       Walter  F.  Tichy,  RCS--A  System  for  Version  Control,
       Software--Practice  &  Experience  15,  7   (July   1985),
       637-654.






GNU                         1995/06/05                          3


