#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif

#ifdef PDCDEBUG
char *rcsid__getrows = "$Header: C:\CURSES\private\RCS\_getrows.c 2.1 1993/06/18 20:22:53 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_get_rows()	- Return number of screen rows.

  PDCurses Description:
 	This is a private PDCurses routine.

 	Returns the maximum number of rows supported by the display.
 	e.g.  25, 28, 43, 50, 60, 66...

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int PDC_get_rows( void );

**man-end**********************************************************************/

int	PDC_get_rows(void)
{
#ifdef	DOS
	char *env_rows;
	int		rows;
#endif

#ifdef	OS2
	VIOMODEINFO modeInfo;
	int		rows;
	char *env_rows;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_rows() - called\n");
#endif

#ifdef	FLEXOS
		return (vir.vc_size.rs_nrows);
#endif

#ifdef	DOS
/* use the value from LINES environment variable, if set. MH 10-Jun-92 */
/* and use the minimum of LINES and *ROWS.                MH 18-Jun-92 */
	rows = getdosmembyte(0x484) + 1;
	env_rows = (char *)getenv("LINES");
	if (env_rows != (char *)NULL)
		rows = min(atoi(env_rows),rows);

	if ((rows == 1) && (_cursvar.adapter == _MDS_GENIUS))
		rows = 66;
	if ((rows == 1) && (_cursvar.adapter == _MDA))
		rows = 25;  /* new test MH 10-Jun-92 */
	if (rows == 1)
	{
		rows = _default_lines;	/* Allow pre-setting LINES	 */
		_cursvar.direct_video = FALSE;
	}
	switch (_cursvar.adapter)
	{
	case _EGACOLOR:
	case _EGAMONO:
		switch (rows)
		{
		case 25:
		case 43:
			break;
		default:
			rows = 25;
		}
		break;

	case _VGACOLOR:
	case _VGAMONO:
/* lets be reasonably flexible with VGAs - they could be Super VGAs */
/* capable of displaying any number of lines. MH 10-Jun-92          */
/*
		switch (rows)
		{
		case 25:
		case 28:
		case 50:
			break;
		default:
			rows = 25;
		}
*/
		break;

	default:
		rows = 25;
		break;
	}
	return (rows);
#endif

#ifdef	OS2
/* use the value from LINES environment variable, if set. MH 10-Jun-92 */
/* and use the minimum of LINES and *ROWS.                MH 18-Jun-92 */

	modeInfo.cb = sizeof(modeInfo);
	VioGetMode(&modeInfo, 0);
	rows = modeInfo.row;
	env_rows = (char *)getenv("LINES");
	if (env_rows != (char *)NULL)
		rows = min(atoi(env_rows),rows);
	return(rows);
#endif
#ifdef UNIX
	return(lines);
#endif
}
