#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	prefresh

#ifdef PDCDEBUG
char *rcsid_prefresh = "$Header: C:\CURSES\portable\RCS\prefresh.c 2.1 1993/06/18 20:20:46 MH Rel MH $";
#endif




/*man-start*********************************************************************

  prefresh()	- refresh pad

  X/Open Description:
 	The prefresh routine copies the specified pad to the physical
 	terminal screen.  It takes account of what is already
 	displayed on the screen to optimize cursor movement.

 	The pnoutrefresh routine copies the named pad to the virtual
 	screen. It then compares the virtual screen with the physical
 	screen and performs the actual update.

 	These routines are analogous to the routines wrefresh and
 	wnoutrefresh except that pads, instead of windows, are
 	involved.  Additional parameters are also needed to indicate
 	what part of the pad and screen are involved. The upper left
 	corner of the part of the pad to be displayed is specified by
 	py and px.  The coordinates sy1, sx1, sy2, and sx2 specify the
 	edges of the screen rectangle that will contain the selected
 	part of the pad.

 	The lower right corner of the pad rectangle to be displayed is
 	calculated from the screen co-ordinates.  This ensures that
 	the screen rectangle and the pad rectangle are the same size.

 	Both rectangles must be entirely contained within their
 	respective structures.

  PDCurses Description:
 	Contrary to the statements above, the pnoutrefresh() routine
 	will not perform an update to the physical screen.  This task
 	is performed by doupdate().

  X/Open Return Value:
 	The prefresh() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to pass a null WINDOW* pointer.

  Portability:
 	PDCurses	int prefresh( WINDOW* win, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );
 	X/Open Dec '88	int prefresh( WINDOW* win, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );
 	SYS V Curses	int prefresh( WINDOW* win, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );

**man-end**********************************************************************/

int	prefresh(WINDOW* win,int py,int px,int sy1,int sx1,int sy2,int sx2)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("prefresh() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	pnoutrefresh(win, py, px, sy1, sx1, sy2, sx2);
	doupdate();
	return( OK );
}
