#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	cbreak

#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif

#ifdef PDCDEBUG
char *rcsid_cbreak = "$Header: C:\CURSES\portable\RCS\cbreak.c 2.1 1993/06/18 20:19:40 MH Rel MH $";
#endif




/*man-start*********************************************************************

  cbreak()	- set/clear cbreak mode

  X/Open Description:	cbreak() and nocbreak()
 	These two routines put the terminal into and out of cbreak mode.
 	In cbreak mode, characters typed by the user are immediately
 	available to the program and erase/kill character processing is
 	not performed.  When out of cbreak mode, the terminal driver
 	will buffer characters typed until a newline or carriage return
 	is typed.  Interrupt and flow control characters are unaffected
 	by this mode.  Initially the terminal may or may not need be
 	in cbreak mode.

  PDCurses Description:
 	There is no additional PDCurses functionality.

  X/Open Return Value:
 	The cbreak() function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for these functions.

  Portability:
 	PDCurses	int cbreak( void );
 	X/Open Dec '88	int cbreak( void );
 	BSD Curses	int cbreak( void );
 	SYS V Curses	int cbreak( void );

**man-end**********************************************************************/

int	cbreak(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("cbreak() - called\n");
#endif

#ifdef UNIX
#ifdef USE_TERMIO
	_CUR_TERM.prog_mode.c_lflag &= ~(ICANON);
	_CUR_TERM.prog_mode.c_iflag &= ~(ICRNL);
/*	_CUR_TERM.prog_mode.c_lflag |= ISIG;*/
	_CUR_TERM.prog_mode.c_cc[VMIN] = 1;
	_CUR_TERM.prog_mode.c_cc[VTIME] = 0;
	ioctl(_CUR_TERM.fd, TCSETAW, &_CUR_TERM.prog_mode);
#else
	_CUR_TERM.prog_mode.sg_flags |= CBREAK;
	ioctl(_CUR_TERM.fd, TIOCSETP, &_CUR_TERM.prog_mode);
#endif

#endif

	_cursvar.cbreak = TRUE;
	return( OK );
}
