NAME
     find - search for files in a directory hierarchy

SYNOPSIS
     find [path...] [expression]

DESCRIPTION
     This manual page documents the GNU version of find.   find  searches  the
     directory  tree  rooted  at  each  given pathname by evaluating the given
     expression from left to right, according to the rules of precedence  (see
     section  OPERATORS), until the outcome is known (left hand side false for
     and operations, true for or), at which point find moves on  to  the  next
     pathname.

     The first argument that begins with `-', `(', `)', `,', or `!'  is  taken
     to  be the beginning of the expression; any arguments before it are paths
     to search, and any arguments after it are the rest of the expression.  If
     no  paths  are given, the current directory is used.  If no expression is
     given, the expression `-print' is used.

     find exits with status 0 if all files are processed successfully, greater
     than 0 if errors occur.

EXPRESSIONS

     The expression is made up of  options  (which  affect  overall  operation
     rather  than  the processing of a specific file, and always return true),
     tests (which return a true or false value), and actions (which have  side
     effects  and  return  a true or false value), all separated by operators.
     -and is assumed  where  the  operator  is  omitted.   If  the  expression
     contains  no  actions other than -prune, -print is performed on all files
     for which the expression is true.

     OPTIONS

     -daystart
          Measure times (for -amin, -atime, -cmin, -ctime, -mmin, and  -mtime)
          from the beginning of today rather than from 24 hours ago.

     -depth
          Process each directory's contents before the directory itself.

     -follow
          Dereference symbolic links.

     -maxdepth levels
          Descend  at  most  levels  (a  non-negative   integer)   levels   of
          directories  below  the command line arguments.  `-maxdepth 0' means
          only apply the tests and actions to the command line arguments.

     -mindepth levels
          Do not apply any tests or actions at levels less than levels (a non-
          negative integer).  `-mindepth 1' means process all files except the
          command line arguments.

     -version
          True; print find version number on standard error.

     -xdev
          True; don't descend directories on other filesystems.

     TESTS

     Numeric arguments can be specified as

     +n   for greater than n,

     -n   for less than n,

     n    for exactly n.

     -amin n
          File was last accessed n minutes ago.

     -anewer file
          File was  last  accessed  more  recently  than  file  was  modified.
          -anewer  is affected by -follow only if -follow comes before -anewer
          on the command line.

     -atime n
          File was last accessed n*24 hours ago.

     -cmin n
          File's status was last changed n minutes ago.

     -cnewer file
          File's status was last changed more recently than file was modified.
          -cnewer  is affected by -follow only if -follow comes before -cnewer
          on the command line.

     -ctime n
          File's status was last changed n*24 hours ago.

     -empty
          File is empty and is either a regular file or a directory.

     -false
          Always false.

     -fstype type
          File is on a filesystem of type type.  The  valid  filesystem  types
          vary  among  different  versions  of  Unix;  an  incomplete  list of
          filesystem types that are  accepted  on  some  version  of  Unix  or
          another is: ufs, 4.2, 4.3, nfs, tmp, mfs, S51K, S52K.

     -gid n
          File's numeric group ID is n.

     -group gname
          File belongs to group gname (numeric group ID allowed).

     -inum n
          File has inode number n.

     -links n
          File has n links.

     -lname pattern
          File is a symbolic link whose contents match shell pattern  pattern.
          `*'  and  `?'  match  `.'  at the start of the link contents.  Slash
          characters have no special meaning in the comparison.

     -mmin n
          File's data was last modified n minutes ago.

     -mtime n
          File's data was last modified n*24 hours ago.

     -name pattern
          Base of path name (the path with the  leading  directories  removed)
          matches  shell pattern pattern.  `*' and `?' do not match `.' at the
          start of the filename.

     -newer file
          File was modified more recently than file.  -newer  is  affected  by
          -follow only if -follow comes before -newer on the command line.

     -nouser
          No user corresponds to file's numeric user ID.

     -nogroup
          No group corresponds to file's numeric group ID.

     -perm mode
          File's permission bits are exactly mode (octal or symbolic).

     -perm -mode
          Permission bits mode are set for the file.

     -regex pattern
          Pathname matches regular expression pattern.

     -size n[ck]
          File uses n 512-byte blocks (bytes if `c' follows  n,  kilobytes  if
          `k'  follows  n).  The size does not count indirect blocks, and does
          count blocks in sparse files that are not actually allocated.

     -true
          Always true.

     -type c
          File is of type c:

     b    block (buffered) character

     c    character (unbuffered) character

     d    directory

     p    named pipe (FIFO)

     f    regular file

     l    symbolic link

     s    socket

     -uid n
          File's numeric user ID is n.

     -used n
          File was last accessed n days after its status was last changed.

     -user uname
          File is owned by user uname (numeric user ID allowed).

     -xtype c
          The same as -type unless the file is a symbolic link.  For  symbolic
          links,  if -follow has not been given, true if the file is a link to
          a file of type c; if -follow has been given, true if c is `l'.   For
          symbolic  links,  -xtype checks the type of the file that -type does
          not check.

     ACTIONS

     -exec command ;
          Execute command; true  if  0  status  is  returned.   All  following
          arguments  to find are taken to be arguments to the command until an
          argument consisting of `;'  is  encountered.   The  string  `{}'  is
          replaced  by  the  current  pathname  being  processed everywhere it
          occurs in the arguments to the command.  Both of these constructions
          might need to be escaped (with a `\') or quoted to protect them from
          expansion by the shell.

     -fprint file
          True; print the full pathname into file  file.   If  file  does  not
          exist  when  find  is  run,  it  is created; if it does exist, it is
          truncated.  The filenames ``/dev/stdout''  and  ``/dev/stderr''  are
          handled  specially;  they  refer to the standard output and standard
          error output, respectively.

     -fprint0 file
          True; like -print0 but write to file like -fprint.

     -fprintf file format
          True; like -printf but write to file like -fprint.

     -ok command ;
          Like -exec but ask user first; if the response does not  start  with
          `y' or `Y', do not run the command, and return false.

     -print
          True; print the full pathname on the standard output, followed by  a
          newline.

     -print0
          True; print the full pathname on the standard output, followed by  a
          null  character.   This allows filenames that contain newlines to be
          correctly interpreted by programs that process the find output.

     -printf format
          True; print format on the standard output, interpreting `\'  escapes
          and `%' directives.  Field widths and precisions can be specified as
          with the `printf' C function.  The escapes and directives are:

     \a   Alarm bell.

     \b   Backspace.

     \c   Stop printing from this format immediately.

     \f   Form feed.

     \n   Newline.

     \r   Carriage return.

     \t   Horizontal tab.

     \v   Vertical tab.

     A `\' character followed by any other character is treated as an ordinary
     character, so they both are printed.

     %%   A literal percent sign.

     %a   File's last access time in the format  returned  by  the  C  `ctime'
          function.

     %Ak  File's last access time in the  format  specified  by  k,  which  is
          either  `@'  or  a  directive  for  the  C `strftime' function.  The
          possible values for k are listed below; some of them  might  not  be
          available  on  all systems, due to differences in `strftime' between
          systems.

     @    seconds since Jan. 1, 1970, 00:00 GMT.

     Time fields:

     H    hour (00..23)

     I    hour (00..12)

     M    minute (00..59)

     p    locale's AM or PM

     r    time, 12-hour (hh:mm:ss [AP]M)

     S    second (00..61)

     T    time, 24-hour (hh:mm:ss)

     X    locale's time representation (H:M:S)

     Z    time zone (e.g., EDT), or nothing if no time zone is determinable

     Date fields:

     a    locale's abbreviated weekday name (Sun..Sat)

     A    locale's full weekday name, variable length (Sunday..Saturday)

     b    locale's abbreviated month name (Jan..Dec)

     B    locale's full month name, variable length (January..December)

     c    locale's date and time (Sat Nov 04 12:02:33 EST 1989)

     d    day of month (01..31)

     D    date (mm/dd/yy)

     h    same as b

     j    day of year (001..366)

     m    month (01..12)

     U    week number of year with Sunday as first day of week (00..53)

     w    day of week (0..6)

     W    week number of year with Monday as first day of week (00..53)

     x    locale's date representation (mm/dd/yy)

     y    last two digits of year (00..99)

     Y    year (1970...)

     %b   File's size in 512-byte blocks (rounded up).

     %c   File's last status change time in  the  format  returned  by  the  C
          `ctime' function.

     %Ck  File's last status change time in the format specified by  k,  which
          is the same as for %A.

     %d   File's depth in the directory tree; 0 means the file  is  a  command
          line argument.

     %f   File's pathname with any leading directories removed.

     %g   File's group name, or numeric group ID if the group has no name.

     %G   File's numeric group ID.

     %h   Leading directories of file's pathname.

     %H   Command line argument under which file was found.

     %i   File's inode number (in decimal).

     %k   File's size in 1K blocks (rounded up).

     %l   Object of symbolic link (empty string if  file  is  not  a  symbolic
          link).

     %m   File's permission bits (in octal).

     %n   Number of hard links to file.

     %p   File's pathname.

     %P   File's pathname with the name of the  command  line  argument  under
          which it was found removed.

     %s   File's size in bytes.

     %t   File's last modification time  in  the  format  returned  by  the  C
          `ctime' function.

     %Tk  File's last modification time in the format specified by k, which is
          the same as for %A.

     %u   File's user name, or numeric user ID if the user has no name.

     %U   File's numeric user ID.

     A `%' character followed by any other character  is  discarded  (but  the
     other character is printed).

     -prune
          If -depth is not given, true; do not descend the current directory.
          If -depth is given, false; no effect.

     -ls  True; list current file in `ls -dils'  format  on  standard  output.
          The  block  counts are of 1K blocks, unless the environment variable
          POSIX_ME_HARDER is set, in which case 512-byte blocks are used.

     OPERATORS

     Listed in order of decreasing precendence:

     ( expr )
          Force precedence.

     ! expr
          True if expr is false.

     -not expr
          Same as ! expr.

     expr1 expr2
          And (implied); expr2 is not evaluated if expr1 is false.

     expr1 -a expr2
          Same as expr1 expr2.

     expr1 -and expr2
          Same as expr1 expr2.

     expr1 -o expr2
          Or; expr2 is not evaluated if expr1 is true.

     expr1 -or expr2
          Same as expr1 -o expr2.

     expr1 , expr2
          List; both expr1 and expr2 are always evaluated.  The value of expr1
          is discarded; the value of the list is the value of expr1.
