NAME
        diff -- show differences between files.

SYNOPSIS
        diff [options] file1 file2
        diff [options] dir1  file1
        diff [options] dir1  dir2

DESCRIPTION
        In the simplest case, diff compares the contents of the
        two files file1 and file2.  A file name of - stands for
        text read from the standard input.  As a special case,
        diff - - compares a copy of standard input to itself.

        If dir1 is a directory and file1 is a filename, diff
        compares the file in dir1 whose filename is that of file1.
        The directory and filename arguments may be in either
        order.  The filename must not be -, since standard input
        is nameless.

        If both arguments are directories, diff compares
        corresponding files in both directories, in alphabetical
        order; this comparison is not recursive unless the -r
        or --recursive option is given.  diff never compares the
        actual contents of a directory as if it were a file.

        diff options begin with -, so normally from-file and
        to-file may not begin with -.  However, -- as an argument
        by itself treats the remaining arguments as file names
        even if they begin with -.

        An exit status of 0 means no differences were found, 1
        means some differences were found, and 2 means trouble
        (inaccessible or missing argument, or system error).

OPTIONS: INPUT, OUTPUT, DIRECTORIES.
        Options control the interpretation of input, format of
        the output, and how to handle directory comparisons.
        Multiple single letter options (unless they take an
        argument) can be combined into a single command line
        word: -ac is equivalent to -a -c.  Long named options
        can be abbreviated to any unique prefix of their name.
        Brackets ([ and ]) indicate that an option takes an
        optional argument.

INPUT OPTIONS
        These control the way in which file contents are interpreted,
        and the algorithm used.

    -a, --text
        Treat all files as text and compare them line-by-line,
        even if they do not seem to be text.

    -b, --ignore-space-change
        Ignore changes in amount of blank and tab whitespace.
        See also -w.

    -B, --ignore-blank-lines
        Ignore changes that just insert or delete blank lines.
        See also -I.

    -d, --minimal
        Change the algorithm to perhaps find a smaller set of
        changes.  This makes diff slower (sometimes much slower).

    -h
        No effect in GNU diff.  For compatibility with Unix diff
        option for "hasty" comparison.

    -H, --speed-large-files
        Use heuristics to speed handling of large files that have
        numerous scattered small changes.

    -i, --ignore-case
        Ignore changes in case; consider upper- and lower-case
        letters equivalent.

    -I regexp, --ignore-matching-lines=regexp
        Ignore changes that just insert or delete lines that
        match regexp.

    -w, --ignore-all-space
        Ignore horizontal whitespace when comparing lines.
        -b considers "a b" and "a  b" equivalent, but not "ab".
        -w considers all three the same.

OUTPUT OPTIONS (SIMPLE)
        These control the format of the output.  Options that change the
        overall format (such as -c, -e, -u, etc) are mutually exclusive.

     -"lines"
        Show lines (an integer) lines of context.  This option
        does not specify an output format by itself; it has no
        effect unless it is combined with -c or -u.  This option
        is obsolete.

    -c
        Use the context output format.

    -C [lines], --context[=lines]
        Use the context output format, showing lines (an integer)
        lines of context, or three if lines is not given.

    -e, --ed
        Make output that is a valid ed script.

    -f, --forward-ed
        Make output that looks vaguely like an ed script but has
        changes in the order they appear in the file.

    -F regexp, --show-function-line=regexp
        In context and unified format, for each hunk of
        differences, show some of the last preceding line
        that matches regexp.

    -l, --paginate
        Pass the output through pr to paginate it.

    -L label, --label=label
        Use label instead of the file name in the context format
        and unified format headers.

    --left-column
        Print only the left column of two common lines in side by
        side format.

    -n, --rcs
        Output RCS-format diffs; like -f except that each command
        specifies the number of lines affected.

    -p, --show-c-function
        Show which C function each change is in.

    -q, --brief
        Report only whether the files differ, not the details of
        the differences.

    -s, --report-identical-files
        Report when two files are the same.

    --suppress-common-lines
        Do not print common lines in side by side format.

    -t, --expand-tabs
        Expand tabs to spaces in the output, to preserve
        the alignment of tabs in the input files.  This is
        to counteract the effect of inserting characters that
        indicate the nature of the differences at the beginning
        of each line, in certain output formats.

    -T, --initial-tab
        Output a tab rather than a space before the text of a line
        in normal or context format.  This causes the alignment
        of tabs in the line to look normal.

    -u
        Use the unified output format.

    -U [lines], --unified[=lines]
        Use the unified output format, showing lines (an integer)
        lines of context, or three if lines is not given.

    -v, --version
        Output the version number of diff.

    -W columns, --width=columns
        Use an output width of columns in side by side format.

    -y, --side-by-side
        Use the side by side output format.

OUTPUT OPTIONS (ADVANCED)
    --changed-group-format=format
        Use format to output a line group containing differing
        lines from both files in if-then-else format.

    -D name
        Make merged #ifdef format output, conditional on the
        preprocessor macro name.

    --ifdef=name
        Make merged if-then-else output using format.

    --new-group-format=format
        Use format to output a group of lines taken from just the
        second file in if-then-else format.

    --new-line-format=format
        Use format to output a line taken from just the second
        file in if-then-else format.

    --old-group-format=format
        Use format to output a group of lines taken from just the
        first file in if-then-else format.

    --old-line-format=format
        Use format to output a line taken from just the first file
        in if-then-else format.

    --sdiff-merge-assist
        Print extra information to help sdiff.  sdiff uses this
        option when it runs diff.  This option is not intended
        for users to use directly.

    --unchanged-group-format=format
        Use format to output a group of common lines taken from
        both files in if-then-else format.

    --unchanged-line-format=format
        Use format to output a line common to both files in
        if-then-else format.

DIRECTORY OPTIONS
        These options apply when comparing two directories.

    -N, --new-file
        In directory comparison, if a file is found in only one
        directory, treat it as present but empty in the other
        directory.

    -P, --unidirectional-new-file
        When comparing directories, if a file appears only in the
        second directory of the two, treat it as present but empty
        in the other.

    -r, --recursive
        When comparing directories, recursively compare any
        subdirectories found.

    -S file, --starting-file=file
        When comparing directories, start with the file file.
        This is used for resuming an aborted comparison.

    -x pattern, --exclude=pattern
        When comparing directories, ignore files and subdirectories
        whose basenames match pattern.

    -X file, --exclude-from=file
        When comparing directories, ignore files and subdirectories
        whose basenames match any pattern contained in file.


SEE ALSO
        cmp(1), comm(1), diff3(1), ed(1).

NOTES
     1. For more information see ``Comparing and Merging Files''
        by D MacKenzie, P Eggart, and R Stallman.  This manual page
        is derived from section 12 (Invoking diff) of edition 1.1
        for diff 2.1 (January 1983).
