/**[txh]********************************************************************

  Description:
  This header defines which functions must be defined for each supported
compiler.@p

  Copyright (c) 2000-2001 by Salvador E. Tropea
  Covered by the GPL license.

***************************************************************************/

#include <tv/configtv.h>

#ifdef TVComp_GCC
 // GNU c is supported for various OSs:
 
 #define NEEDS_GETCURDIR
 
 // Win32 MinGW
 #ifdef TVCompf_MinGW
  #define NEEDS_FIXPATH
  #define NEEDS_GLOB
  #define NEEDS_FNMATCH
  #define NEEDS_REGEX
  #define NEEDS_GETOPT
  #define NEEDS_MKSTEMP
 #endif
 
 // Win32 Cygwin
 #ifdef TVCompf_Cygwin
  #define NEEDS_FIXPATH
  #define NEEDS_FILELENGTH
 #endif
 
 // DOS djgpp
 #ifdef TVCompf_djgpp
  #define NEEDS_GETOPT
 #endif
 
 // Linux
 #ifdef TVOSf_Linux
  // Strings
  #define NEEDS_STRLWR
  #define NEEDS_STRUPR
  #define NEEDS_FIXPATH
  #define NEEDS_FILELENGTH
  #define NEEDS_ITOA
 #endif
 
 // Generic UNIX system
 #if defined(TVOS_UNIX) && !defined(TVOSf_Linux)
  // Strings
  #define NEEDS_STRLWR
  #define NEEDS_STRUPR
  #define NEEDS_FIXPATH
  #define NEEDS_FILELENGTH
  #define NEEDS_ITOA
 #endif
#endif


// BC++ 5.5 for Win32 is supported
#ifdef TVComp_BCPP
 #define NEEDS_FIXPATH
 #define NEEDS_GLOB
 #define NEEDS_FNMATCH
 #define NEEDS_UNC
 #define NEEDS_REGEX
 #define NEEDS_GETOPT
 #define NEEDS_OPENDIR
 #define NEEDS_MKSTEMP
#endif


// MSVC will be supported if volunteers tests it or Microsoft decides to
// give it for free ;-). After all Borland released BC++ 5.5.
#if (defined(_MSVC) || defined(__MSC_VER)) && !defined(_MSC_VER)
#define _MSC_VER
#endif

#ifdef TVComp_MSC
 #define NEEDS_GETCURDIR
 #define NEEDS_FIXPATH
 #define NEEDS_GLOB
 #define NEEDS_FNMATCH
 #define NEEDS_REGEX
 #define NEEDS_GETOPT
 #define NEEDS_MKSTEMP
#endif
