/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Little usefull graphical objects
	File       : Include/Gadgets/ScrolText.H
	Author     : Eric NICOLAS
	Overview   : TTextScroller object
	UpDate     : Mar 01, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_SCROLTXT_H_
#define _GADGETS_SCROLTXT_H_

class TTextScroller;

// --- TTextScroller  object

extern short RegTTextScroller;
extern char *IdentTTextScroller;

class TTextScroller : public TScroller
{ DECLARE(TTextScroller);
  // --- Datas
  protected:
    int    NLines,NCols;
    int    WFont, HFont;
    PChar *TextCache;
    PChar *ColorCache;
    int    CacheLgn1,CacheLgn2;
    int    CacheLgns;
  // --- Functions
  public:
  // Public constructors
			 TTextScroller(void);
			 TTextScroller(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert);
          TTextScroller(TRect R, TLift *_Horiz, TLift *_Vert);
  // Construction / Destruction
          void     Defaults(void);
			 void     Init(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert);
  // Gestion du texte
          void     SetTextSize(int _NCols, int _NLines, boolean Apply=TRUE);
          void     SetCharVisible(int Col, int Line, boolean Apply=TRUE);
  virtual char    *GetText(int Line);
  virtual char    *GetColors(int Line);
          void     UpdateCache(void);
  // Trac
  virtual void     Draw(TRect Clip);
};

#endif // _GADGETS_SCROLTXT_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   01/03/96 :EN: Moving from struct to class. Adding Defaults() method
** ------------------------------------------------------------------------*/
