// Associated include file : ToolBox/Image/ImgFile.H

// Much part of the reading/writing file formats is from the
// Independent JPEG Group's software and is copyright by it.
// This code was adapted to the C++ fashion by Cedric JOULAIN and
// Eric NICOLAS.
// The adaptation is copyright (C) 1995-1996, The SWORD Group

#include "sword.h"
#include "toolbox/image/imgfile.h"
#include "toolbox/image/rdfile.h"

// ==== Global PROCS

// ---- Parts ported from CDJPEG program from IJG

// Error Handling

struct my_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */
  jmp_buf setjmp_buffer;	   /* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

METHODDEF void my_error_exit (j_common_ptr cinfo)
{ /* cinfo->err really points to a my_error_mgr struct, so coerce pointer */
  my_error_ptr myerr = (my_error_ptr) cinfo->err;
  /* Tells SWORD there was a JPEG error */
/* %%TODO Error= */
  /* Return control to the setjmp point */
  longjmp(myerr->setjmp_buffer, 1);
}

// Different formats managment

static cjpeg_source_ptr select_file_type(j_compress_ptr cinfo, FILE *infile)
{ int c;
  // Read the first char of the file in order to guess what type it is
  c=getc(infile);
  ungetc(c,infile);
  switch (c)
  { case 'B':  return jinit_read_bmp(cinfo);
    case 'G':  return jinit_read_gif(cinfo);
    case 'P':  return jinit_read_ppm(cinfo);
    case 0x00: return jinit_read_targa(cinfo);
    default:
      Error=erImageFormatNotSupported;
      break;
  }
  return NULL;
}

// ===== TImage object

short RegTImage;
char *IdentTImage = "TImage";

DEFINE(TImage);

TImage::TImage()
{ Defaults();
}

TImage::TImage(int Width, int Height)
{ Defaults();
  Init(Width,Height);
}

void TImage::Defaults(void)
{ R=G=B=NULL;
}

void TImage::Init(int Width, int Height)
{ // Herited Creations
  TScreenBitmap::Init(Width,Height);
  // Other Creations
}

void TImage::FreeMemory(void)
{ // Herited memory liberations
  TScreenBitmap::FreeMemory();
  // Other memory liberations
  SafeDelete(R);
  SafeDelete(G);
  SafeDelete(B);
}

void TImage::GetMemory(void)
{ // Herited memory allocations
  TScreenBitmap::GetMemory();
  // Other memory allocations
  R=G=B=NULL;
  int size=W*H;
  // Get the memory
  if (size)
  { SafeNew(R,byte[size]);
	 SafeNew(G,byte[size]);
	 SafeNew(B,byte[size]);
  }
}

void TImage::Load(char *Name)
{ TDisk *file;
  // Try to open the file
  file=new TDisk(Name,stOpen);
  if (Error)
  { delete file;
    return;
  }
  // Look to the extension to see wether it begans with 'j' or 'J'
  // If yes, we assume it is a JPEG file
  int  i;
  char c='\0';
  for(i=0;Name[i]!='\0';i++)
	 if (Name[i]=='.') c=Name[i+1];
  // If it is a JPEG, call read_JPEG_file, else call Load_OtherFormat
  // (both from IJG software library)
  if ((c!='J') && (c!='j')) LoadOtherFormat(file);
							  else LoadJPEG(file);
  // Ferme le fichier
  delete file;
  // Place l'image dans le buffer au format de l'cran
  RawToScreen();
}

void TImage::LoadJPEG(TDisk *file)
{ // This struct contains the JPEG decompression parameters and pointers to
  // working space (which is allocated as needed by the JPEG library).
  struct jpeg_decompress_struct cinfo;
  struct my_error_mgr           jerr;        // private JPEG error handler.
  JSAMPARRAY                    buffer;	   // Output row buffer
  int                           row_stride;	// physical row width in buffer
  int                           I, Pos;
  //
  BeginPhase("Reading Image JPEG file...");
  // Step 1: allocate and initialize JPEG decompression object
  // :: We set up the normal JPEG error routines, then override error_exit.
  cinfo.err=jpeg_std_error(&jerr.pub);
  jerr.pub.error_exit = my_error_exit;
  // :: Establish the setjmp return context for my_error_exit to use.
  if (setjmp(jerr.setjmp_buffer))
  { // If we get here, the JPEG code has signaled an error.
	 // We need to clean up the JPEG object, close the input file, and return.
	 jpeg_destroy_decompress(&cinfo);
	 EndPhase();
	 return;
  }
  // :: Now we can initialize the JPEG decompression object.
  jpeg_create_decompress(&cinfo);
  // Step 2: specify data source (eg, a file)
  jpeg_stdio_src(&cinfo, file->Handle());
  // Step 3: read file parameters with jpeg_read_header()
  jpeg_read_header(&cinfo, TRUE);
  // Step 4: Start decompressor
  jpeg_start_decompress(&cinfo);
  // Step 5: Change image parameters depending on what we found in the file
  // :: JSAMPLEs per row in output buffer
  row_stride=cinfo.output_width * cinfo.output_components;
  // :: Make a one-row-high sample array that will go away when done with image
  buffer=(*cinfo.mem->alloc_sarray)
         ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
  // :: Change the size of the datas according to real image size
  NewSize(cinfo.output_width,cinfo.output_height);
  if (Error)
  { jpeg_destroy_decompress(&cinfo);
  	 EndPhase();
    return;
  }
  // Step 6: lecture de l'image
  Pos = 0;
  while (cinfo.output_scanline < cinfo.output_height)
  { jpeg_read_scanlines(&cinfo,buffer,1);
	 // Assume put_scanline_someplace wants a pointer and sample count.
	 if (cinfo.output_components==1)
	 { // This is GreyScale JPEG
		for(I=0;I<cinfo.output_width;I++,Pos++)
		{ R[Pos] = buffer[0][I];
		  G[Pos] = buffer[0][I];
		  B[Pos] = buffer[0][I];
		}
	 }
	 else
	 { // This is TrueColor JPEG
		for(I=0;I<cinfo.output_width;I++,Pos++)
		{ R[Pos] = buffer[0][I*3];
		  G[Pos] = buffer[0][I*3+1];
		  B[Pos] = buffer[0][I*3+2];
		}
	 }
    AvancePhase(100*cinfo.output_scanline/cinfo.output_height);
  }
  // Step 7: Finish decompression
  jpeg_finish_decompress(&cinfo);
  // Step 8: Release JPEG decompression object
  jpeg_destroy_decompress(&cinfo);
  EndPhase();
}

void TImage::LoadOtherFormat(TDisk *file)
{ struct jpeg_compress_struct cinfo;
  struct my_error_mgr         jerr;        // private JPEG error handler.
  int                         I, Pos;
  cjpeg_source_ptr            src_mgr;
  JDIMENSION                  num_scanlines;
  //
  BeginPhase("Reading Image file...");
  // Step 1: allocate and initialize JPEG decompression object
  // :: We set up the normal JPEG error routines, then override error_exit.
  cinfo.err=jpeg_std_error(&jerr.pub);
  jpeg_create_compress(&cinfo);
  jerr.pub.error_exit = my_error_exit;
  // :: Establish the setjmp return context for my_error_exit to use.
  if (setjmp(jerr.setjmp_buffer))
  { // If we get here, the JPEG code has signaled an error.
	 // We need to clean up the JPEG object, close the input file, and return.
	 EndPhase();
	 return;
  }
  // Initialize JPEG parameters.
  // Much of this may be overridden later.
  // In particular, we don't yet know the input file's color space,
  // but we need to provide some value for jpeg_set_defaults() to work.
  cinfo.in_color_space = JCS_RGB;      // arbitrary guess
  jpeg_set_defaults(&cinfo);
  // Figure out the input file format, and set up to read it.
  src_mgr=select_file_type(&cinfo, file->Handle());
  if (Error)
  { EndPhase();
	 return;
  }
  src_mgr->input_file=file->Handle();
  // Read the input file header to obtain file size & colorspace.
  (*src_mgr->start_input)(&cinfo, src_mgr);
  // Now that we know input colorspace, fix colorspace-dependent defaults
  jpeg_default_colorspace(&cinfo);
  // Fix the image size
  NewSize(cinfo.image_width,cinfo.image_height);
  if (Error)
  { (*src_mgr->finish_input) (&cinfo, src_mgr);
	 EndPhase();
	 return;
  }
  // Specify data destination for compression
  jpeg_stdio_dest(&cinfo, NULL);
  // Start compressor
  jpeg_start_compress(&cinfo, TRUE);
  // Process data
  Pos = 0;
  while (cinfo.next_scanline < cinfo.image_height)
  { num_scanlines = (*src_mgr->get_pixel_rows) (&cinfo, src_mgr);
	 for(I=0;I<cinfo.image_width;I++, Pos++)
	 {	R[Pos] = (src_mgr->buffer)[0][I*3];
		G[Pos] = (src_mgr->buffer)[0][I*3+1];
		B[Pos] = (src_mgr->buffer)[0][I*3+2];
	 }
	 cinfo.next_scanline+=num_scanlines;
	 AvancePhase(100*cinfo.next_scanline/cinfo.image_height);
  }
  // Finish compression and release memory
  (*src_mgr->finish_input) (&cinfo, src_mgr);
  jpeg_destroy_compress(&cinfo);
  EndPhase();
}

void TImage::Save(char */*Name*/)
{
}

void TImage::RawToScreen(void)
{ int   i,j;
  byte *Rp=R;
  byte *Gp=G;
  byte *Bp=B;

  // Fill the device context with our image
  BeginDraw();
  for(j=0;j<H;j++)
	 for(i=0;i<W;i++)
	 { GrPlot(i,j,Dither->GetRGBColor(i,j,*Rp,*Gp,*Bp));
		Rp++;
		Gp++;
		Bp++;
	 }
  EndDraw();
}