/*
    Run-time dynamic linking of DLL functions and data
*/

#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include "dlltest.h"

typedef int WINAPI (*DLLFUNC) (void);

int main(int argc, char **argv)
{
    HINSTANCE hLib;		/* handle of the DLL */
    DLLFUNC lpfnFunc1;          /* address of DLL function */
    DLLFUNC lpfnFunc2;          /* address of DLL function */

    /* --- load the library --- */

    hLib = LoadLibrary("dlltest.dll");
    if (!hLib) {
	DWORD err = GetLastError();
	printf("Cannot load dll fails err=0x%lX = %ld\n", err, err);
	exit(1);
    }

    /* --- get the address of the exported functions --- */

    lpfnFunc1 = (DLLFUNC) GetProcAddress(hLib, "DllFunction1");
    if (!lpfnFunc1) {
	printf("Error: GetProcAddress(Maximum)\n");
	exit(1);
    }
    lpfnFunc2 = (DLLFUNC) GetProcAddress(hLib, "DllFunction2");
    if (!lpfnFunc2) {
	printf("Error: GetProcAddress(Minimum)\n");
	exit(1);
    }

    /* --- access the dll --- */

    puts("Try to call func1");
    (*lpfnFunc1)();

    puts("Try to call func2");
    (*lpfnFunc2)();

    FreeLibrary(hLib);

    return 0;
}
