/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> RADIO.H
 -> Radio button control.
*/

#ifndef _radio_h
#define _radio_h

#include <types.h>
#include <tws/window.h>

#define RADIO_TYPE_NONE    0
#define RADIO_TYPE_RAISED  1
#define RADIO_TYPE_LOWERED 2
#define RADIO_TYPE_BUMP    3
#define RADIO_TYPE_DIP     4

class RadioButton:public Window {
   public:
      RadioButton(Window *parent,int y,int len,ControlID ID,char *text);
      ~RadioButton();

      void Select();
      void SelectWithoutFocus();
      void DeSelect();

      ControlID GetControlID()
         { return ID; }
      int IsSelected()
         { return isSelected; }

   protected:
      void PaintWindow(int,int,int,int);
      void Focus();
      void UnFocus();
      void LButtonDown(int,int,int);

      DECLARE_RESPONSE_TABLE;

      char *text;
      ControlID ID;
      int isSelected;
};

class RadioButtonContainer:public Window {
   public:
      RadioButtonContainer(Window *parent,int x1,int y1,int x2,int y2,int type=RADIO_TYPE_NONE);
      ~RadioButtonContainer();

      void AddButton(char *text,ControlID ID);
      void SelectButton(ControlID ID);
      ControlID GetSelectedButton();

   protected:
      void PaintWindow(int,int,int,int);
      void Focus();
      void UnFocus();
      void KeyUp(int);
      void KeyDown(int);

      DECLARE_RESPONSE_TABLE;

      Window *old_focus;
      int n,len,type;
      RadioButton **buttons;
};



#endif
