/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> LISTBOX.H
 -> ListBox class declaration.
*/

#ifndef _listbox_h
#define _listbox_h

#include <types.h>
#include <tws/scrolwin.h>

#define E_LISTBOX(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==5000) \
   { \
      function(); \
      return TRUE; \
   }

#define E_LISTBOXSELECT(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==5001) \
   { \
      function(); \
      return TRUE; \
   }


class ListBox:public ScrollingWindow {
   public:
      ListBox(Window *parent,ControlID ID,int x1,int y1,int x2,int y2);
      ~ListBox();

      char *GetSelectionName();
      void AddItem(char *name);
      void SelectItem(int n);

   protected:
      void PaintWindow(int,int,int,int);
      void LButtonDown(int,int,int,int);
      void KeyUp(int);
      void KeyDown(int);
      void KeyEnter(int);
      void Focus();
      void UnFocus();
      inline int ItemLength(int n)
         {return 42+StringWidth(item_name[n],SysFont);}
      
      int selected,focused;
      int nitems,len;
      char **item_name;
      ControlID ID;

      DECLARE_RESPONSE_TABLE;
};


#endif
