/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: towctrans.c,v 1.1 1996/10/27 13:23:28 jack Exp $ */

#include <stddef.h>
#include <wctype.h>
#include <wcprvt.h>

#define WCRANGE (0)
#define MINRANGE (0)
#define MAXRANGE (1)
#define DIFFRANGE (2)

wint_t
towctrans (wint_t wc, wctrans_t type)
{
  struct __wcclass *wcclass;
  int diff;
  int num;
  int i;

  /* verify type */
  if (type == 0 || type < 0 || type > __wcprops_trans_num)
    return wc;

  /* get classification */
  wcclass = __wcprops_trans[type - 1]->wcclass;

  /* search */
  for (i = 0; (num = wcclass[i].num) >= 0; i++)
    {
      if (num == WCRANGE)
	{
	  /* in range */
	  if (wc >= wcclass[i].wchars[MINRANGE] && wc <= wcclass[i].wchars[MAXRANGE])
	    {
	      /* add diff's value (conversion) */
	      diff = (int) wcclass[i].wchars[DIFFRANGE];
	      wc = (wint_t) ((int) wc + diff);
	      break;
	    }
	}
    }

  /* return result */
   return wc;
}
