/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsstr.c,v 1.2 1996/08/01 08:13:33 jack Exp $ */

#include <stddef.h>
#include <mbstring.h>

unsigned char *
_mbsstr (const unsigned char *us1, const unsigned char *us2)
{
  const unsigned char *up;
  int c;
  size_t len;

  up = us1;
  c = _mbsnextc (us2);
  len = _mbslen (us2);

  while ((up = _mbschr (up, c)) != NULL)
    {
      if (_mbsncmp (up, us2, len) == 0)
	return (unsigned char *) up;
      up += _mbclen (up);
    }

  return NULL;
}
