// Copyright (C) 1997 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

// This file is contributed by
// Markus F.X.J. Oberhumer <markus.oberhumer@jk.uni-linz.ac.at>


#ifndef PrimitiveModelBuilderClass 
#define PrimitiveModelBuilderClass 

#include <Lib3d/ModelBuilder.H>

class PrimitiveModelBuilder : public ModelBuilder
{
public:
    enum { FACE_OUTSIDE = 1, FACE_INSIDE = 2, FACE_BOTH = 3 };

    uint addCube ( float width, float height, float depth,
                   int face = FACE_OUTSIDE );
    uint addCube ( float size, int face = FACE_OUTSIDE );
};

#endif

