/****************************************************************************/
/* JPHELP                                                                   */
/*--------------------------------------------------------------------------*/
/* JPTUI Help                                                               */
/*--------------------------------------------------------------------------*/
/* Author     : DELPRAT Jean-Pierre (jpdelprat@teaser.fr)                   */
/* Crated on  : 05-MAY-97                                                   */
/* Modified on: 05-MAY-97                                                   */
/****************************************************************************/


//-- Includes --

#include <dos.h>
#include <iostream>
#include <stdlib.h>

#include "..\..\jptui.h"

using namespace std;

/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

/*ͻ*/
/*                                WIDGETS                                 */
/*ͼ*/


//-- APPLICATION -------------------------------------------------------------

TApplication  JPHelp(ENGLISH);

// HELP WINDOW

THelpWindow       HelpWindow     (1,1,80,25,
				  "JPTUI Help",
				  NOT_MODAL,
				  NOT_MOVABLE);


//void QuitCall(PObject, const char*)
//{
//  JPStop();
//}

namespace {

class CallbacksWrapper : public jptui::Callback
{
public:
	void	operator()(TObject* who, what_type what, item_type item);
};

CallbacksWrapper	callbacksWrapper;

} // namespace

void	CallbacksWrapper::operator()(TObject* who, what_type what, item_type item)
{
	JPStop();
}

/*ͻ*/
/*                            MAIN PROGRAM                                */
/*ͼ*/


int main(int argc, char *argv[])
{
  bool help_wanted=false;
  char          no_ext_help_file [MAX_PATH];
  char          *help_file;
  char          *default_ext=".HLP";
  char          *ptr;

  if (argc!=2)
    help_wanted=true;
  else
    {
      if (!stricmp(argv[1],"/?"))
        help_wanted=true;
    }

  if (help_wanted)
      {
	cout << "\nJPTUI Help File Viewer for JPTUI " << JPTUI_VERSION_STRING;
	cout << "\nBy Jean-Pierre Delprat, " << JPTUI_DATE_STRING;
	cout << "\nDisplays a JPTUI hypertext help file.\n\n";

	cout << "Usage : JPHELP <Help File> [/?]\n\n";
        cout << "        Help File : JPTUI Help file to view (default extension : .HLP)\n";
	cout << "        /?        : Displays this help\n\n";
	exit(EXIT_SUCCESS);
      }

  if (!FullPath(no_ext_help_file,argv[1]))
    {
      cout << "Invalid file name\n\n";
      exit(EXIT_FAILURE);
    }


  help_file=new char [strlen(no_ext_help_file)+strlen(default_ext)+1];
  strcpy(help_file,no_ext_help_file);
  ptr=strchr(help_file,'.');
  if (ptr==NULL)
    {
      ptr=strchr(help_file,0);
      strcpy(ptr,default_ext);
    }

  SetFullScreenMode();
  JPInit();

  HelpWindow.setCloseButtonPressedCallback(callbacksWrapper, 0);
  HelpWindow.closedAction_.set(callbacksWrapper, 0);	// m_set_closed_callback(QuitCall,"");

  HelpWindow.m_load_help_file(help_file);
  HelpWindow.m_open();
  JPRun();
  return(0);
}
